<?php
/**
 * Created by PhpStorm.
 * User: Alberto Pallotto
 * Date: 23/04/2019
 * Time: 10:33
 */

namespace Drop\FatturazioneElettronica\Controller\Adminhtml\TaxvatNumeration;

use Magento\Framework\Controller\ResultFactory;

class Add extends \Magento\Backend\App\Action
{
    /**
     * @var \Magento\Framework\Registry
     */
    private $coreRegistry;
    /**
     * @var \Drop\FatturazioneElettronica\Model\TaxvatNumerationFactory
     */
    private $taxvatFactory;


    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\Registry $coreRegistry ,
     * @param \Webkul\Grid\Model\GridFactory $gridFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Drop\FatturazioneElettronica\Model\TaxvatNumerationFactory $taxvatFactory
    )
    {
        parent::__construct($context);
        $this->taxvatFactory = $taxvatFactory;
        $this->coreRegistry = $coreRegistry;
    }

    /**
     * Mapped Grid List page.
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        $rowId = (int)$this->getRequest()->getParam('id');
        $rowData = $this->taxvatFactory->create();
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        if ($rowId) {
            $rowData = $rowData->load($rowId);
            $countries = $rowData->getCountries();
            if (!$rowData->getId()) {
                $this->messageManager->addError(__('row data no longer exist.'));
                $this->_redirect('efatt/taxvatnumeration/');
                return;
            }
        }

        $this->coreRegistry->register('taxvat_data', $rowData);
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $title = $rowId ? __('Edit Custom Taxvat/Numeration ') . $countries : __('Add Custom Taxvat/Numeration');
        $resultPage->getConfig()->getTitle()->prepend($title);
        return $resultPage;
    }
}