define([
    'Magento_Ui/js/form/element/abstract',
    'jquery',
    'ko'
], function (Abstract, $, ko) {
    'use strict';

    /**
     * @todo: Suddividere in 2 controllori: 1 per request-invoice e uno per custopmer-typology
     */
    return Abstract.extend({

        currentCountry: null,
        reqRequestInvoiceCountries: null,
        reqBusinessCustomerTypology: null,
        configValues: null,
        debug: null,

        /**
         * Initialize data
         */
        initialize: function () {
            this._super();

            if(this.configValues == null) {
                this.configValues = window.checkoutConfig; //KO Checkout configuration

                if(this.debug == null) {
                    this.debug = this.configValues.fatturazione_elettronica.debug;
                    this.consoleLog('this.debug' + this.debug);
                }
                if(this.reqRequestInvoiceCountries == null) {
                    this.reqRequestInvoiceCountries = this.configValues.fatturazione_elettronica.req_request_invoice_countries;
                    this.consoleLog('this.reqRequestInvoiceCountries');
                    this.consoleLog(this.reqRequestInvoiceCountries);
                }
                if(this.reqBusinessCustomerTypology == null) {
                    this.reqBusinessCustomerTypology = this.configValues.fatturazione_elettronica.req_business_customer_typology;
                    this.consoleLog('this.reqBusinessCustomerTypology');
                    this.consoleLog(this.reqBusinessCustomerTypology);
                }
            }
        },

        /**
         * Show request invoice dependent fields if request_invoice is already checked
         * @param checkbox
         * @returns {exports}
         */
        requestInvoiceAfterLoadProcessor: function (checkbox) {
            var self = this;

            this.hideAll();
            this.setCurrentCountry();

            if((this.currentCountry != '') && (this.currentCountry != undefined)) {
                //Qui nascondo e basta perchè di base è tutto mostrato
                if(this.currentCountry != 'IT') {
                    this.hideNotItalianFields();
                }

                if(this.isMandatoryRequest()) {
                    this.hideMandatoryRequestFields();
                }
            }

            $('select[name="country_id"]').on('change', function() {
                //All change devo gestire mostra/nascondi invece

                self.setCurrentCountry();
                self.resetAll();

                if((this.value != '') && (this.value != undefined)) {
                    //Hide not italian fields
                    if((this.value != 'IT')) {
                        self.hideNotItalianFields();
                    }

                    //Mandatory invoice request
                    if(self.isMandatoryRequest()) {
                        self.hideMandatoryRequestFields();
                    } else {
                        self.showMandatoryRequestFields();
                    }

                    //Manage mandatory customer typology business
                    if(self.isMandatoryBusinessTypology()) {
                        self.customerTypologyOnlyBusiness();
                    } else {
                        self.customerTypologyResetOnlyBusiness();
                    }

                }
            });

            //INIT: If request_invoice is already checked, show related fields
            if ($('.request_invoice input[type="checkbox"]').prop('checked')) {
                this.consoleLog('Invoice request is already checked. Show is-request-invoice fields.')
                this.show($(".show-is-request-invoice"));

                //If customer typology is already checked sto related fields
                var radios = new Object();
                radios.value = $('.customer_typology input[type="radio"]:checked').val();
                this.customerTypologyChangeProcessor(radios);
                return this;
            }

        },

        /**
         * Show request invoice dependent fields if request_invoice is changed
         * @param checkbox
         * @returns {exports}
         */
        requestInvoiceChangeProcessor: function (checkbox) {
            this.hideAll();

            //Show fields if is changed to checked
            if (checkbox.value === true) {
                this.consoleLog('Request invoice was checked. Showing depend fields')
                this.show($(".show-is-request-invoice"));

                //If customer typology is already checked show related fields
                var radios = new Object();
                radios.value = $('.customer_typology input[type="radio"]:checked').val();
                this.customerTypologyChangeProcessor(radios);
                return this;
            }
        },

        /**
         * Show customer typology values dependent fields if customer_typology is already checked
         * @param checkbox
         * @returns {exports}
         */
        customerTypologyAfterLoadProcessor: function (radios) {
            this.customerTypologyHideAll();
            this.setCurrentCountry();

            if((this.currentCountry != '') && (this.currentCountry != undefined)) {
                //Hide not italian fields
                if(this.currentCountry != 'IT') {
                    this.hideNotItalianFields();
                }

                //Mandatory customer typology business
                if(this.isMandatoryBusinessTypology()) {
                    this.customerTypologyOnlyBusiness();
                }
            }

            //INIT: Show field if customer typology and request_invoice is already checked
            if($('.request_invoice input[type="checkbox"]').prop('checked')) {
                var customerTypologyRadioChecked = $('.customer_typology input[type="radio"]:checked').val();
                if ((customerTypologyRadioChecked === 0 || customerTypologyRadioChecked === '0')) {
                    this.customerTypologyShowPerson();
                }
                if (customerTypologyRadioChecked === 1 || customerTypologyRadioChecked === '1') {
                    this.customerTypologyShowBusiness();
                }
            }
        },

        /**
         * Show customer typology values dependent fields if customer_typology is changed
         * @param checkbox
         * @returns {exports}
         */
        customerTypologyChangeProcessor: function (radios) {
            this.customerTypologyHideAll();

            //Show field if customer typology change to checked
            if (radios.value === 0 || radios.value === '0') {
                this.customerTypologyShowPerson();
            }
            if (radios.value === 1 || radios.value === '1') {
                this.customerTypologyShowBusiness();
            }

        },

        /**
         * Setter/Getter
         */
        setCurrentCountry: function() {
            this.currentCountry = $('select[name="country_id"]').val();
            this.consoleLog('currentCountry: ' + this.currentCountry);
        },

        /**
         * Check backoffice request_invoice and customer_typology configuration
         * @returns {boolean}
         */
        isMandatoryRequest: function() {
            return this.reqRequestInvoiceCountries.indexOf(this.currentCountry) != -1;
        },
        isMandatoryBusinessTypology: function() {
            return this.reqBusinessCustomerTypology.indexOf(this.currentCountry) != -1;
        },

        /**
         * Only Italian fields management
         */
        hideNotItalianFields: function() {
            this.consoleLog('NOT ITALIAN Country: Hide reception_destination, fiscal_code, customer_typology')
            this.hide($(".reception_destination, .fiscal_code, .customer_typology"));
        },
        showItalianFields: function() {
            this.consoleLog('ITALIAN Country: Show reception_destination, fiscal_code, customer_typology')
            this.show($(".reception_destination, .fiscal_code, .customer_typology"));
        },

        /**
         * Request fields management
         * @returns {exports}
         */
        hideMandatoryRequestFields: function() {
            this.consoleLog('MANDATORY REQUEST: Checking and hiding request invoice checkbox')
            if(!$('.request_invoice input[type="checkbox"]').prop('checked')) {
                $('.request_invoice input[type="checkbox"]').trigger('click');
            }
            $('.request_invoice').hide();

            if(this.currentCountry == 'IT') {
                this.show($('.show-is-request-invoice'));
                return this;
            }
            this.hideNotItalianFields();
        },
        showMandatoryRequestFields: function() {
            this.consoleLog('NOT MANDATORY REQUEST: Showing request invoice checkbox')
            $('.request_invoice').show();
        },

        /**
         * Customer typology management
         */
        customerTypologyResetOnlyBusiness: function() {
            this.consoleLog('NOT MANDATORY BUSINESS. Showing person option')
            $('#customer_typology_0, label[for="customer_typology_0"]').show();
        },
        customerTypologyOnlyBusiness: function() {
            this.consoleLog('MANDATORY BUSINESS. Only business field, hiding fiscal code')
            $('#customer_typology_0, label[for="customer_typology_0"]').hide();
            $('#customer_typology_1').prop('checked', true).trigger('click');
            this.hide($('.fiscal_code'));
            if($('.request_invoice input[type="checkbox"]').prop('checked')) {
                this.customerTypologyShowBusiness();
            }
        },
        customerTypologyHideAll: function() {
            this.consoleLog('HIDING Customer Typology all: person and business fields')
            this.hide($(".show-is-person, .show-is-business"));
        },
        customerTypologyShowBusiness: function() {
            this.consoleLog('Customer typology: Showing BUSINESS and hiding persons')
            this.hide($(".show-is-person"));
            this.show($(".show-is-business"));
        },
        customerTypologyShowPerson: function() {
            this.consoleLog('Customer typology: Showing PERSON and hiding business')
            this.show($(".show-is-person"));
            this.hide($(".show-is-business"));
        },

        /**
         * Hide show with required management functions
         * @param element
         */
        hideAll: function() {
            this.consoleLog('HIDE ALL');
            this.hide($(".show-is-request-invoice, .show-is-person, .show-is-business"));
        },
        resetAll: function() {
            this.consoleLog('Country CHANGE: uncheck request invoice checkbox, uncheck customer typology, hide all request_invoice, person and business fields')
            if($('.request_invoice input[type="checkbox"]').prop('checked')) {
                $('.request_invoice input[type="checkbox"]').trigger('click');
            }
            this.hideAll();
        },
        hide: function(element) {
            element.hide().removeClass('required fe-required-entry');
        },
        show: function(element) {
            element.show().addClass('required fe-required-entry');
        },
        consoleLog: function(message) {
            if(this.debug) { console.log(message); }
        }
    });
});
