<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Drop\FatturazioneElettronica\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\SalesSequence\Model\Builder;
use Magento\SalesSequence\Model\EntityPool;
use Magento\SalesSequence\Model\Config;
use Magento\Framework\Event\ObserverInterface;

/**
 * Class CreateSequence
 */
class SequenceCreatorObserver implements ObserverInterface
{
    const ADMIN_STORE_ID = 0;
    /**
     * @var Builder
     */
    private $sequenceBuilder;
    /**
     * @var Config
     */
    private $sequenceConfig;

    /**
     * Initialization
     *
     * @param Builder $sequenceBuilder
     * @param EntityPool $entityPool
     * @param Config $sequenceConfig
     */
    public function __construct(
        Builder $sequenceBuilder,
        Config $sequenceConfig
    )
    {
        $this->sequenceBuilder = $sequenceBuilder;
        $this->sequenceConfig = $sequenceConfig;
    }

    /**
     * @param EventObserver $observer
     * @return $this
     */
    public function execute(EventObserver $observer)
    {
        $data = $observer->getData('data');
        $entityTypes = ['fe_invoice', 'fe_creditmemo'];
        foreach ($entityTypes as $entityType) {
            $customEntity = $entityType . '_' . explode(',', $data['id'])[0];
            $this->sequenceBuilder
                ->setPrefix($data['custom_numeration'])
                ->setSuffix($this->sequenceConfig->get('suffix'))
                ->setStartValue($data['initial_number'])
                ->setStoreId(self::ADMIN_STORE_ID)
                ->setStep($this->sequenceConfig->get('step'))
                ->setWarningValue($this->sequenceConfig->get('warningValue'))
                ->setMaxValue($this->sequenceConfig->get('maxValue'))
                ->setEntityType($customEntity)
                ->create();
        }
        return $this;
    }
}
