<?php

namespace Drop\FatturazioneElettronica\Model\Config\Source;

use \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface;

class StatoLiquidazione implements \Magento\Framework\Option\ArrayInterface
{
    
    const STATO_LIQUIDAZIONE_LS = 'LS';
    const STATO_LIQUIDAZIONE_LN = 'LN';

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => self::STATO_LIQUIDAZIONE_LS, 'label' => __('In liquidazione')],
                ['value' => self::STATO_LIQUIDAZIONE_LN, 'label' => __('Non in liquidazione')]
            ];
        }

        return $this->_options;
    }
}
