define([
    'jquery',
    'mage/utils/wrapper',
    'Magento_Checkout/js/model/quote',
], function ($, wrapper, quote) {
    'use strict';

    return function (setShippingInformationAction) {
        return wrapper.wrap(setShippingInformationAction, function (originalAction, messageContainer) {

            var shippingAddress = quote.shippingAddress();
            if (shippingAddress['extension_attributes'] === undefined) {
                shippingAddress['extension_attributes'] = {};
            }

            console.log('set-shipping-information-mixin')
            console.log(shippingAddress.customAttributes);

            if ((shippingAddress.customAttributes !== undefined)) {
                $.each(shippingAddress.customAttributes, function (key, value) {
                    if ($.isPlainObject(value)) {
                        value = value['value'];
                    }

                    shippingAddress['customAttributes'][key] = value;
                    shippingAddress['extension_attributes'][key] = value;
                });
            }

            console.log(shippingAddress);

            return originalAction(messageContainer);
        });
    };
});
