<?php
/**
 * Group
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */


namespace Drop\FatturazioneElettronica\Model\Config\Structure\Element;

use \Magento\Config\Model\Config\Structure\Element\Group as OriginalGroup;

class Group
{

    private $excludePaymentMethods = [
        'free',
        'purchaseorder'
    ];

    /**
     * @var \Magento\Payment\Helper\Data
     */
    private $paymentHelper;
    /**
     * @var \Drop\FatturazioneElettronica\Model\Config\Source\ModalitaPagamento
     */
    private $modalitaPagamento;

    /**
     * Group constructor.
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        \Magento\Payment\Helper\Data $paymentHelper,
        \Drop\FatturazioneElettronica\Model\Config\Source\ModalitaPagamento $modalitaPagamento
    ) {
        $this->paymentHelper = $paymentHelper;
        $this->modalitaPagamento = $modalitaPagamento;

    }

    /**
     * @return mixed
     */
    private function getAllPaymentMethods() {
        $methodList = $this->paymentHelper->getPaymentMethodList();
        $i = 5;
        foreach($methodList as $code => $label) {
            if(empty($label) || in_array($code, $this->excludePaymentMethods)) {
                continue;
            }
            $options[$code] = [
                'id' => $code,
                'type' => 'select',
                'sortOrder' => ($i * 10),
                'showInDefault' => '1',
                'showInWebsite' => '0',
                'showInStore' => '0',
                'label' => $label . ' - (' . $code . ')',
                'options' => [
                    'option' => $this->getModalitaPagamentoOptions()
                ],
                '_elementType' => 'field',
                'path' => "fatturazione_elettronica/dati_pagamento"
            ];
            $i++;
        }
        return $options;
    }

    /**
     * @return array
     */
    private function getModalitaPagamentoOptions() {
        return $this->modalitaPagamento->toOptionArray();
    }

    /**
     * Override setData when is sendinblue section to add dynamic fields
     * @param OriginalGroup $subject
     * @param callable $proceed
     * @param array $data
     * @param $scope
     * @return mixed
     */
    public function aroundSetData(OriginalGroup $subject, callable $proceed, array $data, $scope) {
        if(($data['path'] == 'fatturazione_elettronica') && ($data['id'] == 'dati_pagamento')) {
            $dynamicFields = $this->getAllPaymentMethods();
            if(!empty($dynamicFields)) {
                $data['children'] += $dynamicFields;
            }
        }
        return $proceed($data, $scope);
    }

}
