<?php

namespace Drop\FatturazioneElettronica\Model\Config\Source;

use \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface;

class RegimeFiscale implements \Magento\Framework\Option\ArrayInterface
{
    
    const REGIME_FISCALE_ORDINARIO = 'RF01';
    const REGIME_FISCALE_CONTRIBUENTI_MINIMI = 'RF02';
    const REGIME_FISCALE_AGRICOLTURA = 'RF03';
    const REGIME_FISCALE_TABACCHI = 'RF04';
    const REGIME_FISCALE_FIAMMIFERI = 'RF05';
    const REGIME_FISCALE_EDITORIA = 'RF06';
    const REGIME_FISCALE_TELEFONIA = 'RF07';
    const REGIME_FISCALE_TRASPORTO = 'RF08';
    const REGIME_FISCALE_INTRATTENIMENTI = 'RF09';
    const REGIME_FISCALE_TURISMO = 'RF10';
    const REGIME_FISCALE_AGRITURISMO = 'RF11';
    const REGIME_FISCALE_DOMICILIO = 'RF12';
    const REGIME_FISCALE_USATO = 'RF13';
    const REGIME_FISCALE_ASTA = 'RF14';
    const REGIME_FISCALE_IVA_PER_CASSA_PA = 'RF15';
    const REGIME_FISCALE_IVA_PER_CASSA = 'RF16';
    const REGIME_FISCALE_ALTRO = 'RF17';
    const REGIME_FISCALE_FORFETTARIO = 'RF18';

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => self::REGIME_FISCALE_ORDINARIO, 'label' => __('Ordinario')],
                ['value' => self::REGIME_FISCALE_CONTRIBUENTI_MINIMI, 'label' => __('Contribuenti minimi (art.1, c.96-117, L. 244/07)')],
                ['value' => self::REGIME_FISCALE_AGRICOLTURA, 'label' => __('Agricoltura e attività connesse e pesca (artt.34 e 34-bis, DPR 633/72)')],
                ['value' => self::REGIME_FISCALE_TABACCHI, 'label' => __('Vendita sali e tabacchi (art.74, c.1, DPR. 633/72)')],
                ['value' => self::REGIME_FISCALE_FIAMMIFERI, 'label' => __('Commercio fiammiferi (art.74, c.1, DPR  633/72)')],
                ['value' => self::REGIME_FISCALE_EDITORIA, 'label' => __('Editoria (art.74, c.1, DPR  633/72)')],
                ['value' => self::REGIME_FISCALE_TELEFONIA, 'label' => __('Gestione servizi telefonia pubblica (art.74, c.1, DPR 633/72)')],
                ['value' => self::REGIME_FISCALE_TRASPORTO, 'label' => __('Rivendita documenti di trasporto pubblico e di sosta (art.74, c.1, DPR  633/72)')],
                ['value' => self::REGIME_FISCALE_INTRATTENIMENTI, 'label' => __('Intrattenimenti, giochi e altre attività di cui alla tariffa allegata al DPR 640/72 (art.74, c.6, DPR 633/72)')],
                ['value' => self::REGIME_FISCALE_TURISMO, 'label' => __('Agenzie viaggi e turismo (art.74-ter, DPR 633/72)')],
                ['value' => self::REGIME_FISCALE_AGRITURISMO, 'label' => __('Agriturismo (art.5, c.2, L. 413/91)')],
                ['value' => self::REGIME_FISCALE_DOMICILIO, 'label' => __('Vendite a domicilio (art.25-bis, c.6, DPR  600/73)')],
                ['value' => self::REGIME_FISCALE_USATO, 'label' => __('Rivendita beni usati, oggetti d’arte, d’antiquariato o da collezione (art.36, DL 41/95)')],
                ['value' => self::REGIME_FISCALE_ASTA, 'label' => __('Agenzie di vendite all’asta di oggetti d’arte, antiquariato o da collezione (art.40-bis, DL 41/95)')],
                ['value' => self::REGIME_FISCALE_IVA_PER_CASSA_PA, 'label' => __('IVA per cassa P.A. (art.6, c.5, DPR 633/72)')],
                ['value' => self::REGIME_FISCALE_IVA_PER_CASSA, 'label' => __('IVA per cassa (art. 32-bis, DL 83/2012)')],
                ['value' => self::REGIME_FISCALE_ALTRO, 'label' => __('Altro')],
                ['value' => self::REGIME_FISCALE_FORFETTARIO, 'label' => __('Regime forfettario (art.1, c.54-89, L. 190/2014)')]
            ];
        }

        return $this->_options;
    }
}
