<?php
/**
 * CreditmemoLoadAfter
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\FatturazioneElettronica\Observer\Sales\Order;

use Magento\Framework\Event\ObserverInterface;

class CreditmemoLoadAfter implements ObserverInterface
{

    /**
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $creditmemo = $observer->getCreditmemo();
        $extensionAttributes = $creditmemo->getExtensionAttributes();
        if ($extensionAttributes === null) {
            $extensionAttributes = $this->getCreditmemoExtensionDependency();
        }

        $feIncrementId = $creditmemo->getData('fe_increment_id');
        $extensionAttributes->setFeIncrementId($feIncrementId);
        $documentType = $creditmemo->getData('document_type');
        $extensionAttributes->setDocumentType($documentType);
        $creditmemo->setExtensionAttributes($extensionAttributes);
    }

    /**
     * @return mixed
     */
    private function getCreditmemoExtensionDependency()
    {
        $creditmemoExtension = \Magento\Framework\App\ObjectManager::getInstance()->get(
            '\Magento\Sales\Api\Data\CreditmemoExtension'
        );
        return $creditmemoExtension;
    }

}
