<?php

namespace Drop\FatturazioneElettronica\Plugin\Magento\Quote\Model;

use Magento\Framework\Exception\CouldNotSaveException;

class ShippingAddressManagementPlugin
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * ShippingAddressManagementPlugin constructor.
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    ) {
        $this->scopeConfig = $scopeConfig;
    }

    public function beforeAssign(
        $subject,
        $cartId,
        $address
    ) {
        $extAttributes = $address->getExtensionAttributes();

        if ($extAttributes) {

            //Force request invoice if current country is in $mandatoryRequestInvoiceCountries array
            $mandatoryRequestInvoiceCountries = explode(',', $this->scopeConfig->getValue('fatturazione_elettronica/general/req_request_invoice_countries'));
            if(in_array($address->getCountryId(), $mandatoryRequestInvoiceCountries)) {
                $extAttributes->setRequestInvoice(1);
            }
            $mandatoryBusinessCustomerTypologyCountries = explode(',', $this->scopeConfig->getValue('fatturazione_elettronica/general/req_business_customer_typology'));
            if(in_array($address->getCountryId(), $mandatoryBusinessCustomerTypologyCountries)) {
                $extAttributes->setCustomerTypology(1);
            }

            try {
                $requestInvoice = $extAttributes->getRequestInvoice();
                $address->setRequestInvoice($requestInvoice);

                $customerTypology = 0;
                $fiscalCode = '';
                $receptionDestination = '';

                if($requestInvoice) {
                    $customerTypology = $extAttributes->getCustomerTypology();
                    $receptionDestination = $extAttributes->getFeReceptionDestination();

                    if($customerTypology == 0) {
                        //Reset entered data based on customer typology
                        $fiscalCode = $extAttributes->getFiscalCode();
                        $address->setVatId('');
                        $address->setCompany('');
                    }
                }

                $address->setCustomerTypology($customerTypology);
                $address->setFiscalCode($fiscalCode);
                $address->setFeReceptionDestination($receptionDestination);

            } catch (\Exception $e) {
                throw new CouldNotSaveException(
                    __('One custom field could not be added to the address.'),
                    $e
                );
            }
        }
    }
}
