<?php

namespace Drop\FatturazioneElettronica\Model\Config\Source;

use \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface;

class TipoDocumento implements \Magento\Framework\Option\ArrayInterface
{
    
    const CONDIZIONI_PAGAMENTO_FATTURA = 'TD01';
    const CONDIZIONI_PAGAMENTO_ACCONTO_FATTURA = 'TD02';
    const CONDIZIONI_PAGAMENTO_ACCONTO_PARCELLA = 'TD03';
    const CONDIZIONI_PAGAMENTO_NDC = 'TD04';
    const CONDIZIONI_PAGAMENTO_NDB = 'TD05';
    const CONDIZIONI_PAGAMENTO_PARCELLA = 'TD06';

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => self::CONDIZIONI_PAGAMENTO_FATTURA, 'label' => __('Fattura')],
                ['value' => self::CONDIZIONI_PAGAMENTO_ACCONTO_FATTURA, 'label' => __('Acconto/anticipo su fattura')],
                ['value' => self::CONDIZIONI_PAGAMENTO_ACCONTO_PARCELLA, 'label' => __('Acconto/anticipo su parcella')],
                ['value' => self::CONDIZIONI_PAGAMENTO_NDC, 'label' => __('Nota di credito')],
                ['value' => self::CONDIZIONI_PAGAMENTO_NDB, 'label' => __('Nota di debito')],
                ['value' => self::CONDIZIONI_PAGAMENTO_PARCELLA, 'label' => __('Parcella')],
            ];
        }

        return $this->_options;
    }
}
