<?php
/**
 * Created by PhpStorm.
 * User: Alberto Pallotto
 * Date: 23/04/2019
 * Time: 14:43
 */

namespace Drop\FatturazioneElettronica\Controller\Adminhtml\TaxvatNumeration;


class Save extends \Magento\Backend\App\Action
{
    /**
     * @var \Webkul\Grid\Model\GridFactory
     */
    var $taxvatFactory;
    /**
     * @var \Magento\Framework\Event\Manager
     */
    var $eventManager;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Webkul\Grid\Model\GridFactory $gridFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Drop\FatturazioneElettronica\Model\TaxvatNumerationFactory $taxvatFactory,
        \Magento\Framework\Event\Manager $eventManager
    )
    {
        parent::__construct($context);
        $this->taxvatFactory = $taxvatFactory;
        $this->eventManager = $eventManager;
    }

    /**
     * @SuppressWarnings(PHPMD.CyclomaticComplexity)
     * @SuppressWarnings(PHPMD.NPathComplexity)
     */
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();

        if (!$data) {
            $this->_redirect('efatt/taxvatnumeration/add');
            return;
        }

        $data['countries'] = implode(',', $data['countries']);

        try {
            $rowData = $this->taxvatFactory->create();
            $rowData->setData($data);
            if (isset($data['id'])) {
                $rowData->setId($data['id']);
            }
            $rowData->save();


            if (isset($data['id'])) {
                $rowData->load($data['id']);
                $data = $rowData->getData();
                $event = 'custom_taxvat_numeration_edit_after';
            } else {
                $data = $rowData->getCollection()
                    ->addFieldToFilter('countries', ['eq' => $data['countries']])
                    ->getFirstItem()
                    ->getData();
                $event = 'custom_taxvat_numeration_add_after';
            }

            $this->eventManager->dispatch($event, ['data' => $data]);
            $this->messageManager->addSuccess(__('Row data has been successfully saved.'));
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
        }
        $this->_redirect('efatt/taxvatnumeration/');
    }
}