<?php

namespace Drop\FatturazioneElettronica\Console\Command;

use Symfony\Component\Console\Input\InputOption;

class FixSequence extends \Symfony\Component\Console\Command\Command
{
    const INI = 'ini-date';
    const END = 'end-date';

    /**
     * @var \Magento\Framework\App\State
     */
    protected $_appState;

    /**
     * @var \Drop\FatturazioneElettronica\Helper\FixSequence
     */
    private $_fixSequence;

    /**
     * @param \Magento\Framework\App\State                   $appState
     * @param \Drop\FatturazioneElettronica\Helper\FixSequence $fixSequence
     */
    public function __construct(
        \Magento\Framework\App\State                     $appState,
        \Drop\FatturazioneElettronica\Helper\FixSequence $fixSequence
    ) {
        $this->_appState    = $appState;
        $this->_fixSequence = $fixSequence;
        parent::__construct();
    }

    protected function configure()
    {
        $options = [
            new InputOption(
                self::INI,
                null,
                InputOption::VALUE_OPTIONAL,
                'get initial date'
            ),
            new InputOption(
                self::END,
                null,
                InputOption::VALUE_OPTIONAL,
                'get end date'
            ),
        ];
        $this->setName('drop:fe:fixsequencefe');
        $this->setDescription('forza il fix delle sequence invoice e credit memo per fe_invoice_id');
        $this->setDefinition($options);
        parent::configure();
    }

    /**
     * @param InputInterface  $input
     * @param OutputInterface $output
     */
    protected function execute(
        \Symfony\Component\Console\Input\InputInterface   $input,
        \Symfony\Component\Console\Output\OutputInterface $output
    ) {
        try {
            $this->_appState->setAreaCode('frontend');
        } catch (\Exception $e) {

        }

        try {
            $dateIni = $input->getOption(self::INI) ?? false;
            $dateEnd = $input->getOption(self::END) ?? false;
            $this->_fixSequence->run($dateIni, $dateEnd);
        } catch (\Exception $e) {
            throw $e;
        }
    }
}
