<?php

namespace Drop\FatturazioneElettronica\Model\Export\Data\Shared;

class Items
{

    /**
     * @var \Magento\Sales\Model\Order\ItemFactory
     */
    protected $orderItemFactory;

    /**
     * @var \Xtento\OrderExport\Model\Export\Data\AbstractData
     */
    protected $abstractData;

    /**
     * FE Items constructor.
     *
     * @param \Magento\Sales\Model\Order\ItemFactory $orderItemFactory
     */
    public function __construct(
        \Magento\Sales\Model\Order\ItemFactory $orderItemFactory
    )
    {
        $this->orderItemFactory = $orderItemFactory;
    }

    public function afterGetExportData(\Xtento\OrderExport\Model\Export\Data\Shared\Items $subject, $returnArray, $entityType, $collectionItem)
    {
        if (empty($returnArray['items'])) {
            return $returnArray;
        }

        $object = $collectionItem->getObject();
        $items = $object->getAllItems();

        $withoutSimpleBundleitemCount = 0;

        if (($entityType == \Xtento\OrderExport\Model\Export::ENTITY_CREDITMEMO) || ($entityType == \Xtento\OrderExport\Model\Export::ENTITY_INVOICE)) {
            $order = $collectionItem->getOrder();
            $orderItemIdArray = [];
            $orderItemPositionCounter = 1;

            foreach ($order->getAllItems() as $orderItem) {
                $orderItemIdArray[$orderItem->getId()] = $orderItemPositionCounter;
                $orderItemPositionCounter++;

                $parentItem = $orderItem->getParentItem();
                if ($parentItem && $parentItem->getProductType() == \Magento\Catalog\Model\Product\Type::TYPE_BUNDLE) {
                    unset($orderItemIdArray[$orderItem->getId()]);
                    $orderItemPositionCounter--;
                }
            }
        }

        if ($entityType == \Xtento\OrderExport\Model\Export::ENTITY_CREDITMEMO && $order && $order->hasInvoices()) {
            $invoiceItemIdArray = [];

            foreach ($order->getInvoiceCollection() as $invoice) {
                $invoiceItemPositionCounter = 1;
                foreach ($invoice->getAllItems() as $invoiceItem) {
                    $invoiceItemIdArray[$invoiceItem->getOrderItemId()] = $invoiceItemPositionCounter;
                    $invoiceItemPositionCounter++;

                    if ($invoiceItem->getParentId()) {
                        //Se ha un parent carico l'item dell'ordine
                        $orderInvoiceItem = $this->orderItemFactory->create()->load($invoiceItem->getOrderItemId());
                        if ($orderInvoiceItem && $orderInvoiceItem->getParentItemId()) {
                            //Se l'item dell'ordine ha un parent lo carico e controllo il tipo, se è bundle decremento
                            $orderInvoiceParentItem = $this->orderItemFactory->create()->load($orderInvoiceItem->getParentItemId());
                            if ($orderInvoiceParentItem && $orderInvoiceParentItem->getProductType() == \Magento\Catalog\Model\Product\Type::TYPE_BUNDLE) {
                                unset($invoiceItemIdArray[$invoiceItem->getOrderItemId()]);
                                $invoiceItemPositionCounter--;
                            }
                        }
                    }
                }
            }
        }

        foreach ($items as $item) {
            $itemId = $item->getId();
            $itemKey = array_search($itemId, array_column($returnArray['items'], 'entity_id'));
            if (!isset($itemKey)) {
                continue;
            }

            $withoutSimpleBundleitemCount++;
            if ($item->getParentId()) {
                //Se ha un parent carico l'item dell'ordine
                $orderItem = $this->orderItemFactory->create()->load($item->getOrderItemId());
                if ($orderItem && $orderItem->getParentItemId()) {
                    //Se l'item dell'ordine ha un parent lo carico e controllo il tipo, se è bundle decremento
                    $orderParentItem = $this->orderItemFactory->create()->load($orderItem->getParentItemId());
                    if (
                        $orderParentItem &&
                        (
                            $orderParentItem->getProductType() == \Magento\Catalog\Model\Product\Type::TYPE_BUNDLE
                            || $orderParentItem->getProductType() == 'configurable'
                        )
                    ) {
                        $returnArray['items'][$itemKey]['is_bundle_child'] = 1;
                        $withoutSimpleBundleitemCount--;
                    }
                }
            }
            $returnArray['items'][$itemKey]['without_simple_of_bundle_line_number'] = $withoutSimpleBundleitemCount;
            if (!empty($orderItemIdArray) && isset($orderItemIdArray[$item->getOrderItemId()])) {
                $returnArray['items'][$itemKey]['without_simple_of_bundle_order_line_number'] = $orderItemIdArray[$item->getOrderItemId()];
            }
            if (!empty($invoiceItemIdArray) && isset($invoiceItemIdArray[$item->getOrderItemId()])) {
                $returnArray['items'][$itemKey]['without_simple_of_bundle_invoice_line_number'] = $invoiceItemIdArray[$item->getOrderItemId()];
            }
        }

        // Done
        return $returnArray;
    }
}
