<?php
/**
 * Created by PhpStorm.
 * User: Alberto Pallotto
 * Date: 26/04/2019
 * Time: 15:48
 */

namespace Drop\FatturazioneElettronica\Model;


class Utilities
{
    const XML_PATH_FE_CEDENTE_PRESTATORE_DENOMINAZIONE = 'fatturazione_elettronica/cedente_prestatore/denominazione';
    const XML_PATH_FE_SEDE_INDIRIZZO = 'fatturazione_elettronica/sede/indirizzo';
    const XML_PATH_FE_SEDE_CIVICO = 'fatturazione_elettronica/sede/civico';
    const XML_PATH_FE_SEDE_CAP = 'fatturazione_elettronica/sede/cap';
    const XML_PATH_FE_SEDE_COMUNE = 'fatturazione_elettronica/sede/comune';
    const XML_PATH_FE_SEDE_PROVINCIA = 'fatturazione_elettronica/sede/provincia';
    const XML_PATH_FE_SEDE_NAZIONE = 'fatturazione_elettronica/sede/nazione';
    const XML_PATH_FE_REA_CAPITALE_SOCIALE = 'fatturazione_elettronica/iscrizione_rea/capitale_sociale';
    const XML_PATH_FE_REA_UFFICIO = 'fatturazione_elettronica/iscrizione_rea/ufficio';
    const XML_PATH_FE_REA_NUMERO = 'fatturazione_elettronica/iscrizione_rea/numero_rea';
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    var $scopeConfig;
    /**
     * @var \Webkul\Grid\Model\GridFactory
     */
    var $taxvatFactory;

    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Drop\FatturazioneElettronica\Model\TaxvatNumerationFactory $taxvatFactory
    )
    {
        $this->scopeConfig = $scopeConfig;
        $this->taxvatFactory = $taxvatFactory;
    }

    /**
     * @param $order
     * @return mixed
     */
    public function getCustomDropPiva($order)
    {
        $model = $this->taxvatFactory->create();
        $customTaxvat = $model->getCollection()
            ->addFieldToFilter('countries', ['like' => '%' . $order->getBillingAddress()->getCountryId() . '%'])
            ->getFirstItem();

        return $customTaxvat->getCustomTaxvat();
    }

    public function getManagedDropAddress($order)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_FE_CEDENTE_PRESTATORE_DENOMINAZIONE) . ' - ' .
            $this->scopeConfig->getValue(self::XML_PATH_FE_SEDE_INDIRIZZO) . ', ' .
            $this->scopeConfig->getValue(self::XML_PATH_FE_SEDE_CIVICO) . ' - ' .
            $this->scopeConfig->getValue(self::XML_PATH_FE_SEDE_CAP) . ' ' .
            $this->scopeConfig->getValue(self::XML_PATH_FE_SEDE_COMUNE) . '(' .
            $this->scopeConfig->getValue(self::XML_PATH_FE_SEDE_PROVINCIA) . ') - ' .
            $this->scopeConfig->getValue(self::XML_PATH_FE_SEDE_NAZIONE) . ' - ' .
            'P.IVA ' . $this->getCustomDropPiva($order);

    }

    public function getReaDropInfo($order)
    {
        return 'Cap. Soc. euro ' .
            $this->scopeConfig->getValue(self::XML_PATH_FE_REA_CAPITALE_SOCIALE) .
            ' interamente sottoscritto e versato - R.E.A. ' .
            $this->scopeConfig->getValue(self::XML_PATH_FE_REA_UFFICIO) . ' ' .
            $this->scopeConfig->getValue(self::XML_PATH_FE_REA_NUMERO) .
            ' - N.iscriz. reg. impr. ' .
            $this->scopeConfig->getValue(self::XML_PATH_FE_REA_UFFICIO) . ' ' .
            'P.IVA ' . $this->getCustomDropPiva($order);
    }
}