# Magento 2 modulo per la fatturazione elettronica

## Installation
- Add the VCS repository to composer:
```sh
$ composer config repositories.drop.fe vcs git@bitbucket.org:dropsrl/drop-module-fatturazione-elettronica.git
```

- Add the module to composer:
```sh
$ composer require drop/module-fatturazione-elettronica
```

- Enable module, install and clear magento cache
```sh
$ bin/magento module:enable Drop_FatturazioneElettronica
$ bin/magento module:enable setup:upgrade
$ bin/magento module:enable cache:clear
```

## Description

- Aggiunta campo customer address Codice Fiscale (fiscal_code)
- Aggiunta campo customer address Tipologia Cliente (customer_typology)
- Aggiunta campo customer address Richiedi Fattura (request_invoice)
- Aggiunta campo customer address Codice Destinatario / Indirizzo PEC (fe_reception_destination)
- Aggiunta dell'esportazione in xml della fattura (per il momento fatto da xtent/order-export
- Creazione di tutti i campi a bo per inserire i dati statici sull'xml

Il campo Tipologia Cliente:
- Obbligatorio se fattura
- E' un radio con valori Azienda o Privato
- Aggiungere alle API di magento

Il campo Codice Fiscale:
- Non serve per chi non richiede fattura
- Obbligatorio per i privati
- Non serve per le aziende
- La Ragione Sociale è il nome/cognome del cliente
- Inserire quindi una select con in quali stati deve essere presente sul checkout (preselezionato a IT)
- E' necessaria Validazione (libreria)
- Aggiungere alle API di magento

Il campo Partita IVA:
- Non serve per chi non richiede fattura
- Obbligatorio per le aziende
- Non serve per i privati
- Deve diventare obbligatorio anche il campo Azienda
- Abilitato per gli stessi stati di Richiedi Fattura (da segnalare con un commento sul bo)
- E' necessaria Validazione (libreria)
- Nel momento dell'installazione settare le configurazioni a quello che ci serve

Il campo Richiedi fattura:
- è sempre valorizzato (e nascosto) (FATTURA) se fuori dall'ue
- è opzionale se dentro l'unione europea
- è una checkbox da spuntare, nel momento in cui la spunti compare il campo Tipologia cliente
- Inserire quindi una select con in quali stati deve essere presente sul checkout (preselezionato a eu)
- Aggiungere alle API di magento

Il campo Codice Destinatario / Indirizzo PEC:
- Obbligatorio
- E' necessaria Validazione o email oppure codice a 7 cifre
- Aggiungere alle API di magento? NON SERVE

Aggiunta di questi campi su:
- Account address solo billing (bo + frontend)
- Checkout solo billing

Opzionale:
- Link sotto campo Codice Fiscale non ricordi il tuo codice fiscale? che prova a calcolarlo

ATTENZIONE:
- Se la richiede bisogna inviare la fattura per email nel momento in cui viene generata
- Controllare che la fattura sia scaricabile dal proprio account (sia per fattura che per proforma)
- Nel momento in cui entrer� la fatturazione elettronica non sar� necessario inviare la fattura per email perch� ci penser� l'agenzia delle entrate
- Tutti i campi aggiunti sul checkout devono essere presenti sulla quote quindi devono "autocompilarsi" anche quando aggiorni la pagina 

Aggiungere funzionalit� di order internals
- Campo numerazione parallela per la fattura e una per la nota di credito
- Questo campo deve essere incrementato come l'increment_id di magento ma deve essere resettato ogni 1 Gennaio
- Aggiunge il campo su documento di fattura e note di credito
- Aggiunge il campo su email di fattura e note di credito
- Aggiungere il campo su dettaglio dell'ordine sul backoffice
- Aggiungere il campo sulle API di magento

## Requirements
- PHP >= 7.0.0
- Mage_Core
- Xtento_OrderExport

## Compatibility
- Magento >= 2.2
- Not tested on 2.1 and 2.0

## Support
If you encounter any problems or bugs, please contact us [here](https://www.drop.it) or create an issue.

## Developer
Cristiano Pieroni (c.pieroni@drop.it)

## Licence
TODO

## Copyright
TODO

## TODO
* Trasformare il campo customer typology in una select invece che in uno yes/no
* Aggiungere il campo customer_typology sul template dell'indirizzo dell'ordine (privato/azienda)
* Aggiungere il tooltip sul customer_typology che spiega chi è privato e chi azienda
* Ordinare i campi anche sul backoffice customer address mettendo vat_id e company alla fine
* Override di customer typology come radio button anche sul backoffice customer address (se non select)
* Aggiungere validazione su partita iva (dovrebbe essere di default di Magento, capire come)
* Aggiungere validazione campi anche su backoffice customer address
* Le traduzioni della label del campo company in Ragione Sociale ci sono, ma prende sempre azienda: fixare
* Aggiungere messaggio su fe_reception_mode : ATTENZIONE: In caso di dati errati, l'ordine non potrà essere spedito
* disabilitare Temando_Shipping a mano perchè fa l'override del template della preview della spedizione sul checkout e a noi non serve
* Link sotto campo Codice Fiscale non ricordi il tuo codice fiscale? che prova a calcolarlo
* Se richiede la fattura bisogna inviarla in allegato all'email nel momento in cui viene generata??
* In futuro sviluppare l'xml custom invece che con Xtento_OrderExport
* Utlizzare Web Service per validazione della fattura elettronica prima di creare la fattura su Magento. Spostare tutto il flusso alla fatturazione se succede qualcosa all'ordine.
