<?php
/**
 * Created by PhpStorm.
 * User: Alberto Pallotto
 * Date: 18/04/2019
 * Time: 12:49
 */

namespace Drop\FatturazioneElettronica\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{
    public function upgrade( SchemaSetupInterface $setup, ModuleContextInterface $context ) {
        $installer = $setup;

        $installer->startSetup();

        if(version_compare($context->getVersion(), '1.0.1', '<')) {
            if (!$installer->tableExists('drop_efatt_taxvatnumeration')) {
                $table = $installer->getConnection()->newTable(
                    $installer->getTable('drop_efatt_taxvatnumeration')
                )
                    ->addColumn(
                        'id',
                        \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        null,
                        [
                            'identity' => true,
                            'nullable' => false,
                            'primary'  => true,
                            'unsigned' => true,
                        ],
                        'id'
                    )
                    ->addColumn(
                        'countries',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        1000,
                        ['nullable => false'],
                        'Countries'
                    )
                    ->addColumn(
                        'custom_taxvat',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        255,
                        [],
                        'Taxvat'
                    )
                    ->addColumn(
                        'custom_numeration',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        255,
                        [],
                        'Numeration Prefix'
                    )
                    ->addColumn(
                        'initial_number',
                        \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        255,
                        [],
                        'Initial Number'
                    )
                    ->setComment('Custom Taxvat - Numeration Table');
                $installer->getConnection()->createTable($table);
            }
        }

        $installer->endSetup();
    }
}