<?php
/**
 * InvoiceLoadAfter
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\FatturazioneElettronica\Observer\Sales\Order;

use Magento\Framework\Event\ObserverInterface;

class InvoiceLoadAfter implements ObserverInterface
{

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $invoice = $observer->getInvoice();
        $extensionAttributes = $invoice->getExtensionAttributes();
        if ($extensionAttributes === null) {
            $extensionAttributes = $this->getInvoiceExtensionDependency();
        }

        $feIncrementId = $invoice->getData('fe_increment_id');
        $extensionAttributes->setFeIncrementId($feIncrementId);
        $documentType = $invoice->getData('document_type');
        $extensionAttributes->setDocumentType($documentType);
        $invoice->setExtensionAttributes($extensionAttributes);
    }


    private function getInvoiceExtensionDependency()
    {
        $invoiceExtension = \Magento\Framework\App\ObjectManager::getInstance()->get(
            '\Magento\Sales\Api\Data\InvoiceExtension'
        );
        return $invoiceExtension;
    }

}
