define([
    'jquery',
    'ko',
    'mageUtils',
    'uiLayout'
], function ($,ko,utils, layout) {
    'use strict';

    var defaultRendererTemplate = {
        parent: '${ $.$data.parentName }',
        name: '${ $.$data.name }',
        component: 'Drop_FatturazioneElettronica/js/view/shipping-information/address-renderer/default',
        provider: 'checkoutProvider'
    };

    var mixin = {

        createRendererComponent: function (address) {
            var rendererTemplate, templateData, rendererComponent;

            $.each(this.rendererComponents, function (index, component) {
                component.visible(false);
            });

            if (this.rendererComponents[address.getType()]) {
                this.rendererComponents[address.getType()].address(address);
                this.rendererComponents[address.getType()].visible(true);
            } else {
                // rendererTemplates are provided via layout
                rendererTemplate = address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined ? //eslint-disable-line
                    utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()]) :
                    defaultRendererTemplate;
                templateData = {
                    parentName: this.name,
                    name: address.getType()
                };

                rendererComponent = utils.template(rendererTemplate, templateData);
                utils.extend(
                    rendererComponent,
                    {
                        address: ko.observable(address),
                        visible: ko.observable(true)
                    }
                );
                layout([rendererComponent]);
                this.rendererComponents[address.getType()] = rendererComponent;
            }
        }
    }

    return function (target) {
        return target.extend(mixin);
    };
});

