/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'uiComponent',
    'underscore',
    'Magento_Customer/js/customer-data'
], function (Component, _, customerData) {
    'use strict';

    var countryData = customerData.get('directory-data');

    return Component.extend({
        defaults: {
            template: 'Drop_FatturazioneElettronica/shipping-information/address-renderer/default'
        },
        //request invoce e customer typology non li mostro che sono per l'utente output incomprensibili (true, e 0/1)
        //feAttributes: ['request_invoice', 'customer_typology', 'fiscal_code', 'fe_reception_destination'],
        feAttributes: ['fiscal_code', 'fe_reception_destination'],
        getIsFeField: function(attribute) {
            if (this.feAttributes.includes(attribute)) {
                return true;
            }

            /**
             * @param {*} countryId
             * @return {String}
             */
        },
        getCountryName: function (countryId) {
            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line
        },

        /**
         * Get customer attribute label
         *
         * @param {*} attribute
         * @returns {*}
         */
        getCustomAttributeLabel: function (attribute) {
            var resultAttribute;

            if (typeof attribute === 'string') {
                return attribute;
            }

            if (attribute.label) {
                return attribute.label;
            }

            //FIX ERRORE MAGENTO 2.3 - vedere https://github.com/magento/magento2/commit/4ef5d3939ee7498f1d0af1257b603e55fb5ff162
            if (typeof this.source.get('customAttributes') !== 'undefined') {
                resultAttribute = _.findWhere(this.source.get('customAttributes')[attribute['attribute_code']], {
                    value: attribute.value
                });
            }

            return resultAttribute && resultAttribute.label || attribute.value;
        }
    });
});
