require([
    'jquery'
], function ($) {
    'use strict';

    var customerAddress = {

        selectedCountry: null,

        /**
         * Init
         */
        init: function()  {
            this.bindRequestInvoice();
            this.bindCustomerTypology();
            this.bindCountryChange();
        },

        /**
         * Request Invoice Management
         */
        bindRequestInvoice: function() {
            var self = this;

            //Show if is already checked
            if($('#request_invoice').is(":checked")) {
                this.show($(".show-is-request-invoice"));
            }

            //Bind change event
            $('#request_invoice').change(function() {
                self.consoleLog('IR Change')
                if(this.checked) {
                    self.consoleLog('Checked')
                    if (self.selectedCountry=='IT'){
                        self.show($(".show-is-request-invoice"));
                    }else{
                        self.show($(".show-is-request-invoice:not(.reception_destination)"));
                    }

                    $('.customer_typology input[type="radio"]:checked').change();
                    return;
                }

                self.consoleLog('Unchecked')
                self.hide($(".show-is-request-invoice"));
                self.hide($(".show-is-person"));
                self.hide($(".show-is-business"));
            });
        },

        /**
         * Customer Typology Management
         */
        bindCustomerTypology: function() {
            var self = this;

            if($("#customer_typology_0").prop("checked")) {
                this.show($(".show-is-person"));
                this.hide($(".show-is-business"));
            }
            if($("#customer_typology_1").prop("checked")) {
                this.hide($(".show-is-person"));
                this.show($(".show-is-business"));
            }

            $("input[type='radio'][name='customer_typology']").change(function() {
                self.consoleLog('CT Change')
                self.consoleLog('IR checked: ' + $('#request_invoice').is(":checked"))
                if($('#request_invoice').is(":checked")) {
                    if (this.value == 0 || this.value == '0') {
                        self.consoleLog('Unchecked')
                        self.show($(".show-is-person"));
                        self.hide($(".show-is-business"));
                    } else if (this.value == 1 || this.value == '1') {
                        self.consoleLog('Checked')
                        self.hide($(".show-is-person"));
                        self.show($(".show-is-business"));
                    }
                }
            });
        },

        bindCountryChange: function() {
            var self = this;

            //Init if not set but have default configuration
            var defaultCountryValue = $('select[name="country_id"]').val();
            if((defaultCountryValue != '') && (defaultCountryValue != undefined)) {
                //Manage mandatory customer typology business
                self.manageFieldData(defaultCountryValue);
            }

            $('select[name="country_id"]').on('change', function() {

                self.consoleLog('ResetAll')
                $('.request_invoice input[type="checkbox"]').prop('checked', false).change();
                $('.customer_typology input[type="radio"]:checked').prop('checked', false).change();
                self.hide($(".show-is-request-invoice"));
                self.hide($(".show-is-person"));
                self.hide($(".show-is-business"));

                if((this.value != '') && (this.value != undefined)) {
                    //Manage mandatory customer typology business
                    self.manageFieldData(this.value);
                }

                self.selectedCountry = this.value;
            });
        },

        isMandatoryRequest: function (value) {
            return reqRequestInvoiceCountries.indexOf(value) != -1;
        },
        isMandatoryBusinessTypology: function (value) {
            return reqBusinessCustomerTypology.indexOf(value) != -1;
        },

        manageFieldData: function(value){
            var self = this;

            console.log(value);
            console.log("Res Bus", reqBusinessCustomerTypology);
            console.log("Res Inv", reqRequestInvoiceCountries);

            // if(self.isMandatoryBusinessTypology(value)) {
            //     self.consoleLog('Required Business')
            //     $('#customer_typology_0, label[for="customer_typology_0"]').hide();
            //     $('#customer_typology_1').prop('checked', true).change();
            // } else {
            //     self.consoleLog('NOT Required Business')
            //     $('#customer_typology_0, label[for="customer_typology_0"]').show();
            // }


            //Mandatory invoice request
            if(self.isMandatoryRequest(value)) {
                self.consoleLog('Required Invoice')
                $('.request_invoice input[type="checkbox"]').prop('checked', true).change();
                $('.request_invoice').hide();

                self.hide($(".show-is-request-invoice"));
            } else {
                self.consoleLog('NOT Required Invoice')
                $('.request_invoice').show();

                if(value != 'IT') {
                    $('#customer_typology_0, label[for="customer_typology_0"]').hide();
                    $('#customer_typology_1').prop('checked', true).change();

                    this.hide($(".reception_destination, .fiscal_code, .customer_typology"));
                }else{
                    $('#customer_typology_0, label[for="customer_typology_0"]').show();
                }
            }
            console.log(value);



        },

        /**
         * Show and hide functions with required
         * @param element
         */
        hide: function(element) {
            console.log("HIDE", element);
            element.hide().removeClass('required');
            element.find('input').removeClass('required-entry');
        },
        show: function(element) {
            console.log("SHOW", element);
            element.show().addClass('required');
            element.find('input').addClass('required-entry');
        },

        consoleLog: function(message) {
            if(feDebug) { console.log(message); }
        }
    };

    $(document).ready(function(){
        customerAddress.init();
    });
});
