<?php

namespace Drop\FatturazioneElettronica\Model\Export\Data\Order;

if(class_exists('\Xtento\OrderExport\Model\Export\Data\AbstractData')) {

        class General extends \Xtento\OrderExport\Model\Export\Data\AbstractData
        {
            public function getConfiguration()
            {
                return [
                    'name' => 'Fatturazioen Elettronica fields',
                    'category' => 'Shared',
                    'description' => 'Export missing fields for fatturazione elettronica.',
                    'enabled' => true,
                    'apply_to' => [\Xtento\OrderExport\Model\Export::ENTITY_ORDER, \Xtento\OrderExport\Model\Export::ENTITY_INVOICE, \Xtento\OrderExport\Model\Export::ENTITY_SHIPMENT, \Xtento\OrderExport\Model\Export::ENTITY_CREDITMEMO, \Xtento\OrderExport\Model\Export::ENTITY_CUSTOMER, \Xtento\OrderExport\Model\Export::ENTITY_QUOTE, \Xtento\OrderExport\Model\Export::ENTITY_AWRMA, \Xtento\OrderExport\Model\Export::ENTITY_BOOSTRMA],
                ];
            }

            public function getExportData($entityType, $collectionItem)
            {
                // Set return array
                $returnArray = [];
                // Fetch fields to export
                $order = $collectionItem->getOrder();

                if ($entityType == \Xtento\OrderExport\Model\Export::ENTITY_ORDER) {
                    $this->writeArray = &$returnArray; // Write directly on order level
                } else {
                    $this->writeArray = &$returnArray['order'];
                }

                if ($order->getInvoiceCollection() && $order->hasInvoices()) {
                    $invoiceCollection = $order->getInvoiceCollection();
                    if (!empty($invoiceCollection)) {
                        $lastInvoice = $invoiceCollection->getLastItem();
                        $this->writeValue('invoice_fe_increment_id', $lastInvoice->getFeIncrementId());
                        $this->writeValue('invoice_grand_total', $lastInvoice->getGrandTotal());
                    }
                }

                // Done
                return $returnArray;
            }
        }

} else {

    class General
    {
    }

}
