<?php


namespace Drop\FatturazioneElettronica\Model;

use Drop\FatturazioneElettronica\Api\StockInterface;
use \Magento\Catalog\Model\Product\Attribute\Source\Status as ProductStatus;
use \Magento\Catalog\Model\Product\Type as ProductType;
use \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use \Magento\CatalogInventory\Api\StockStateInterface;
use \Magento\CatalogInventory\Model\ResourceModel\Stock\Status as StockStatus;

class CustomStockApi
{
    protected $collectionFactory;
    protected $stockState;
    protected $stockStatus;

    /**
     * CustomStockApi constructor.
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory
     * @param \Magento\CatalogInventory\Api\StockStateInterface $stockState
     * @param \Magento\CatalogInventory\Model\ResourceModel\Stock\Status $stockStatus
     */
    public function __construct(
        CollectionFactory $collectionFactory,
        StockStateInterface $stockState,
        StockStatus $stockStatus
    )
    {
        $this->collectionFactory = $collectionFactory;
        $this->stockState = $stockState;
        $this->stockStatus = $stockStatus;
    }

    /**
     * @param null $empty
     * @return array
     */
    public function get($empty = null)
    {
        try {
            $collection = $this->getProductsCollection($empty);
        } catch (\Exception $e) {
            return ['error' => $e->getMessage()];
        }

        $response = [];
        foreach ($collection as $item) {
            if (!$stock = $this->stockState->getStockQty($item->getEntityId())) {
                continue;
            }
            $response[] = [
                'sku' => $item->getSku(),
                'qty' => $stock,
            ];
        }

        return $response;
    }

    /**
     * @param $empty
     * @return mixed
     */
    protected function getProductsCollection($empty)
    {
        $collection = $this->collectionFactory->create()
            ->addAttributeToSelect('*')
            ->addAttributeToFilter('status', ProductStatus::STATUS_ENABLED)
            ->addAttributeToFilter('type_id', ProductType::TYPE_SIMPLE);

        if (!$empty) {
            $this->stockStatus->addIsInStockFilterToCollection($collection);
        }

        return $collection;
    }
}
