define([], function () {
    'use strict';

    var mixin = {
        defaults: {
            detailsTemplate: 'Drop_FatturazioneElettronica/billing-address/details'
        },
        //request invoce e customer typology non li mostro che sono per l'utente output incomprensibili (true, e 0/1)
        //feAttributes: ['request_invoice', 'customer_typology', 'fiscal_code', 'fe_reception_destination'],
        feAttributes: ['fiscal_code', 'fe_reception_destination'],
        getIsFeField: function(attribute) {
            if(this.feAttributes.includes(attribute)) {
                return true;
            }
            return false;
        },
        getCustomAttributeLabel: function (attribute) {
            var resultAttribute;

            if (typeof attribute === 'string') {
                return attribute;
            }

            if (attribute.label) {
                return attribute.label;
            }

            //FIX ERRORE MAGENTO 2.3 - vedere https://github.com/magento/magento2/commit/4ef5d3939ee7498f1d0af1257b603e55fb5ff162
            if (typeof this.source.get('customAttributes') !== 'undefined') {
                resultAttribute = _.findWhere(this.source.get('customAttributes')[attribute['attribute_code']], {
                    value: attribute.value
                });
            }

            return resultAttribute && resultAttribute.label || attribute.value;
        }
    }

    return function (target) {
        return target.extend(mixin);
    };
});
