<?php

namespace Drop\FatturazioneElettronica\Setup;

use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Ddl\Table;

class InstallSchema implements InstallSchemaInterface
{

    /**
     * {@inheritdoc}
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();

        /**
         * Create table 'sequence_fe_invoice_0'
         */
        $sequenceInvoiceTableName = $installer->getTable('sequence_fe_invoice_0');
        $table = $installer->getConnection()->newTable(
            $sequenceInvoiceTableName
        )->addColumn(
            'sequence_value',
            \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
            null,
            ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
            'Sequence Value'
        )->setComment(
            'Sequence table for custom invoice sequence'
        );

        $installer->getConnection()->createTable($table);

        /**
         * Create table 'sequence_fe_creditmemo_0'
         */
        $sequenceCreditmemoTableName = $installer->getTable('sequence_fe_creditmemo_0');
        $table = $installer->getConnection()->newTable(
            $sequenceCreditmemoTableName
        )->addColumn(
            'sequence_value',
            \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
            null,
            ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
            'Sequence Value'
        )->setComment(
            'Sequence table for custom creditmemo sequence'
        );

        $installer->getConnection()->createTable($table);

        /**
         * Add row to manager this created tables on sales_sequence_meta
         */
        $salesSequenceMetaTable = $installer->getTable('sales_sequence_meta');
        $installer->getConnection()->insert(
            $salesSequenceMetaTable,
            [
                'entity_type' => 'fe_invoice',
                'store_id' => 0,
                'sequence_table' => $sequenceInvoiceTableName
            ]
        );

        $installer->getConnection()->insert(
            $salesSequenceMetaTable,
            [
                'entity_type' => 'fe_creditmemo',
                'store_id' => 0,
                'sequence_table' => $sequenceCreditmemoTableName
            ]
        );

        $select = $installer->getConnection()->select()
            ->from($salesSequenceMetaTable, 'meta_id')
            ->where('entity_type = ?', 'fe_invoice');
        $invoiceMetaId = $installer->getConnection()->fetchOne($select);
        if(empty($invoiceMetaId)) {
            $invoiceMetaId = 9; //Default Fallback to do istallation script without errors
        }

        $select = $installer->getConnection()->select()
            ->from($salesSequenceMetaTable, 'meta_id')
            ->where('entity_type = ?', 'fe_creditmemo');
        $creditmemoMetaId = $installer->getConnection()->fetchOne($select);
        if(empty($creditmemoMetaId)) {
            $creditmemoMetaId = 10; //Default Fallback to do istallation script without errors
        }

        $installer->getConnection()->insert(
            $installer->getTable('sales_sequence_profile'),
            [
                'meta_id' => $invoiceMetaId,
                'prefix' => 'DRP-2018-',
                'suffix' => NULL,
                'start_value' => 1,
                'step' => 1,
                'max_value' => 4294967295,
                'warning_value' => 4294966295,
                'is_active' => 1
            ]
        );

        $installer->getConnection()->insert(
            $installer->getTable('sales_sequence_profile'),
            [
                'meta_id' => $creditmemoMetaId,
                'prefix' => 'DRP-2018-',
                'suffix' => NULL,
                'start_value' => 1,
                'step' => 1,
                'max_value' => 4294967295,
                'warning_value' => 4294966295,
                'is_active' => 1
            ]
        );

        $installer->endSetup();
    }
}
