<?php
/**
 * Address
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\FatturazioneElettronica\Model\Data;


class Address extends \Magento\Customer\Model\Data\Address
{

    const FISCAL_CODE = 'fiscal_code';

    /**
     * Get Fiscal code
     *
     * @return string|null
     */
    public function getFiscalCode()
    {
        return $this->_get(self::FISCAL_CODE);
    }


    /**
     * Set Fiscal code
     *
     * @param string $fiscalCode
     * @return $this
     */
    public function setFiscalCode($fiscalCode)
    {
        return $this->setData(self::FISCAL_CODE, $fiscalCode);
    }

}
