<?php

namespace Drop\Faq\Model\Config\Source;

/**
 * BlockOption Dropdown source
 */
class BlockOption implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @var int
     */
    const FIRST = 1;

    /**
     * @var int
     */
    const FLOOR = 2;

    /**
     * @var int
     */
    const BOTH = 3;

    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        return [
            array(
                'value' => self::FIRST,
                'label' => 'Attiva la sezione sfoglia gli articoli dell\'Aiuto',
            ),
            array(
                'value' => self::FLOOR,
                'label' => 'Attiva la sezione consulta le nostre pagine di Aiuto',
            ),
            array(
                'value' => self::BOTH,
                'label' => 'Attiva entrambe le sezioni',
            ),
        ];
    }
}
