<?php

namespace Drop\Faq\Block\Search;

class Search extends \PHPCuong\Faq\Block\Search\Search
{
    /**
     * Get FAQs via text search
     *
     * @return array|bool
     */
    public function getFaqsList()
    {
        $select = $this->_faqResourceModel->getConnection()->select()
            ->from(['faq' => $this->_faqResourceModel->getMainTable()])
            ->joinLeft(
                ['faq_store' => $this->_faqResourceModel->getTable('phpcuong_faq_store')],
                'faq.faq_id = faq_store.faq_id',
                ['store_id']
            )
            ->where('faq_store.store_id = ?', $this->_storeManager->getStore()->getStoreId())
            ->where('faq.is_active = ?', '1');

        $textSearch = $this->clearTextSearch();
        $explode    = explode(' ', $textSearch);

        //maledetto cane phpcuong...

        $whereFullText = "";

        for ($i = 0; $i < count($explode); $i++) {
            if (0 == $i) {
                $whereFullText .= "faq.title LIKE '%" . $explode[$i] . "%'";
            } else {
                $whereFullText .= " OR faq.title LIKE '%" . $explode[$i] . "%'";
            }
            $whereFullText .= " OR faq.content LIKE '%" . $explode[$i] . "%'";
        }

        $select->where($whereFullText);

        $select->group('faq.faq_id');
        $select->order('faq.faq_id DESC');

        if ($results = $this->_faqResourceModel->getConnection()->fetchAll($select)) {
            return $results;
        }

        return false;
    }
}
