<?php

namespace Drop\Email\Model;

use Drop\Email\Helper\VersionCompare;

if (VersionCompare::versionCompare('2.2.8', '=')) {
    /**
     * TransportBuilder class
     */
    class TransportBuilder extends \Eadesigndev\Pdfgenerator\Model\Email\TransportBuilder
    {
        /**
         * {@inheritDoc}
         */
        protected function prepareMessage()
        {
            $template = $this->getTemplate();

            $body = $template->processTemplate();

            switch ($template->getType()) {
                case \Magento\Framework\App\TemplateTypesInterface::TYPE_TEXT:
                    $this->message
                        ->setSubject(html_entity_decode($template->getSubject(), ENT_QUOTES))
                        ->setBodyText($body);
                    break;
                case \Magento\Framework\App\TemplateTypesInterface::TYPE_HTML:
                    $this->message
                        ->setSubject(html_entity_decode($template->getSubject(), ENT_QUOTES))
                        ->setBodyHtml($body);
                    break;
                default:
                    throw new \Magento\Framework\Exception\LocalizedException(
                        new \Magento\Framework\Phrase('Unknown template type')
                    );
            }

            return $this;
        }

        /**
         * {@inheritDoc}
         */
        public function addAttachment(
            $content,
            $mimeType = \Zend\Mime\Mime::TYPE_OCTETSTREAM,
            $disposition = \Zend\Mime\Mime::DISPOSITION_ATTACHMENT,
            $encoding = \Zend\Mime\Mime::ENCODING_BASE64,
            $filename = null
        ) {
            $this->message->setBodyAttachment($content, $filename);

            return $this;
        }

        /**
         * {@inheritDoc}
         */
        public function setFromByStore($from, $store)
        {
            $result = $this->_senderResolver->resolve($from, $store);
            $this->message->setFrom($result['email'], $result['name']);
            return $this;
        }
    }
} else if (VersionCompare::versionCompare('2.2.8', '<')) {
    /**
     * TransportBuilder class
     */
    class TransportBuilder extends \Eadesigndev\Pdfgenerator\Model\Email\TransportBuilder
    {
        /**
         * {@inheritDoc}
         */
        public function setFromByStore($from, $store)
        {
            $result = $this->_senderResolver->resolve($from, $store);
            $this->message->setFrom($result['email'], $result['name']);
            return $this;
        }
    }
}
