<?php

namespace Drop\Email\Model;

use Drop\Email\Helper\VersionCompare;

/**
 * Magento 2.3 does not need fix for TransportBuilder
 */
if (VersionCompare::versionCompare('2.2.8', '=') || VersionCompare::versionCompare('2.2.9', '=')) {
    /**
     * TransportBuilder class
     */
    class TransportBuilder extends \Magento\Framework\Mail\Template\TransportBuilder
    {
        /**
         * {@inheritDoc}
         */
        protected function prepareMessage()
        {
            $template = $this->getTemplate();

            $body = $template->processTemplate();

            switch ($template->getType()) {
                case \Magento\Framework\App\TemplateTypesInterface::TYPE_TEXT:
                    $this->message
                        ->setSubject(html_entity_decode($template->getSubject(), ENT_QUOTES))
                        ->setBodyText($body);
                    break;
                case \Magento\Framework\App\TemplateTypesInterface::TYPE_HTML:
                    $this->message
                        ->setSubject(html_entity_decode($template->getSubject(), ENT_QUOTES))
                        ->setBodyHtml($body);
                    break;
                default:
                    throw new \Magento\Framework\Exception\LocalizedException(
                        new \Magento\Framework\Phrase('Unknown template type')
                    );
            }

            return $this;
        }

        /**
         * {@inheritDoc}
         * @for fix Magento issues #14952 (https://github.com/magento/magento2/issues/14952)
         */
        public function setFromByStore($from, $store)
        {
            $result = $this->_senderResolver->resolve($from, $store);
            $this->message->setFrom($result['email'], $result['name']);
            return $this;
        }
    }
} else {
    class TransportBuilder extends \Magento\Framework\Mail\Template\TransportBuilder
    {
    }
}
