<?php

namespace Drop\Email\Model\Sales\Order\Email;

use Drop\Email\Helper\VersionCompare;

/**
 * SenderBuilder class
 */
if (VersionCompare::versionCompare('2.2.8', '=') || VersionCompare::versionCompare('2.2.9', '=')) {
    class SenderBuilder extends \Magento\Sales\Model\Order\Email\SenderBuilder
    {
        /**
         * {@inheritdoc}
         * @for fix Magento issues #14952 (https://github.com/magento/magento2/issues/14952)
         */
        protected function configureEmailTemplate()
        {
            $this->transportBuilder->setTemplateIdentifier($this->templateContainer->getTemplateId());
            $this->transportBuilder->setTemplateOptions($this->templateContainer->getTemplateOptions());
            $this->transportBuilder->setTemplateVars($this->templateContainer->getTemplateVars());

            $this->transportBuilder->setFromByStore(
                $this->identityContainer->getEmailIdentity(),
                $this->identityContainer->getStore()->getId()
            );
        }
    }
} else {
    class SenderBuilder extends \Magento\Sales\Model\Order\Email\SenderBuilder
    {
    }
}
