<?php

namespace Drop\Email\Plugin\Mageplaza\Smtp\Mail\Rse;

use Magento\Framework\Mail\TransportInterface;
use Zend\Mail\Message as MessageZend;
use Drop\Email\Helper\VersionCompare;
use \Mageplaza\Smtp\Mail\Rse\Mail as MageplazaMail;

if (class_exists(MageplazaMail::class)) {
    class Mail
    {
        public function beforeProcessMessage(
            MageplazaMail $subject,
            $message,
            $storeId
        ) {
            // amazon bug: Transaction failed: Expected disposition, got =
            if (VersionCompare::versionCompare('2.3.4')) {
                $message->getHeaders()->removeHeader("Content-Disposition");
            }

            return [$message, $storeId];
        }
    }
} else {
    class Mail
    {
    }
}
