<?php

namespace Drop\Email\Model;

use Drop\Email\Helper\VersionCompare;

/**
 * Class Message
 */
class Message extends \Magento\Framework\Mail\Message
{
    /**
     * @var mixed
     */
    private $attachment;

    /**
     * alias function
     */
    public function createAttachment(
        $content,
        $mimeType = \Zend\Mime\Mime::TYPE_OCTETSTREAM,
        $disposition = \Zend\Mime\Mime::DISPOSITION_ATTACHMENT,
        $encoding = \Zend\Mime\Mime::ENCODING_BASE64,
        $fileName = null
    ) {
        return $this->setBodyAttachment($content, $fileName);
    }

    /**
     * {@inheritdoc}
     */
    public function setBodyAttachment($content, $fileName)
    {
        $attachmentPart = $this->getPartFactory()->create();

        $attachmentPart->setContent($content)
              ->setType(\Zend\Mime\Mime::TYPE_OCTETSTREAM)
              ->setEncoding(\Zend\Mime\Mime::ENCODING_BASE64)
              ->setFileName($fileName)
              ->setDisposition(\Zend\Mime\Mime::DISPOSITION_ATTACHMENT);

        $this->attachment = $attachmentPart;

        return $this;
    }

    /**
     * {@inheritdoc}
     * @param $fromName for support magento 2.2
     */
    public function setFrom($fromAddress, $fromName = null)
    {
        $this->setFromAddress($fromAddress, $fromName);
        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function setBody($body)
    {
        $attachment = $this->attachment;

        if (isset($attachment)) {
            $body->addPart($attachment);
        }

        return parent::setBody($body);
    }

    /**
     * @return \Zend\Mime\PartFactory
     */
    private function getPartFactory()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
          ->get(\Zend\Mime\PartFactory::class);
    }

    /**
     * @return \Zend\Mail\Message
     * for support change scope from <= 2.3.3 && >= 2.3.4
     */
    private function getZendMessage()
    {
        $zendMessage = \Magento\Framework\App\ObjectManager::getInstance()
          ->get(\Zend\Mail\Message::class);

        $zendMessage->setEncoding('utf-8');

        return $zendMessage;
    }
}
