<?php

namespace Drop\Email\Console\Command;

use Zend\Mime\Mime;
use Magento\Framework\App\Area;
use Magento\Framework\Exception\MailException;

/**
 * TestAttachment class
 */
class TestAttachment extends \Symfony\Component\Console\Command\Command
{
    const TEST_TEMPLATE_IDENTIFIER = 'drop_test_attachment';
    const TEST_FROM_EMAIL = 'general';
    const TEST_TO_EMAIL = 'm.carotti@drop.it';
    const TEST_FILE_CONTENT = 'Test file content.';
    const TEST_FILE_NAME = 'test';
    const TEST_FILE_TYPE = 'pdf';

    /**
     * @var \Drop\Email\Model\TransportBuilder
     */
    protected $transportBuilder;

    /**
     * @var \Magento\Framework\App\State
     */
    protected $state;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Construct
     * @param \Drop\Email\Model\TransportBuilder                 $transportBuilder 
     * @param \Magento\Framework\App\State                       $state            
     * @param string                                             $name             
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig      
     */
    public function __construct(
        \Drop\Email\Model\TransportBuilder $transportBuilder, 
        \Magento\Framework\App\State $state, 
        $name = null,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    )
    {
        $this->transportBuilder = $transportBuilder;
        $this->state = $state;
        $this->scopeConfig = $scopeConfig;
        
        parent::__construct($name);
    }

    /**
     * @inheritdoc
     */
    protected function configure()
    {
        $this->setName('drop:test:attachment');
        $this->setDescription('Test email attachment');
    }

    /**
     * Send test email and write a successful message.
     *
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     * @return void
     */
    protected function execute(
        \Symfony\Component\Console\Input\InputInterface $input, 
        \Symfony\Component\Console\Output\OutputInterface $output
    )
    {
        try {
            $this->state->setAreaCode(Area::AREA_FRONTEND);

            $this->transportBuilder
                ->setTemplateIdentifier(self::TEST_TEMPLATE_IDENTIFIER)
                ->setTemplateOptions(['area' => Area::AREA_FRONTEND, 'store' => 1])
                ->setTemplateVars([])
                ->addAttachment(self::TEST_FILE_CONTENT, self::TEST_FILE_TYPE, Mime::DISPOSITION_ATTACHMENT, Mime::ENCODING_BASE64, self::TEST_FILE_NAME)
                ->setFrom([
                    'name' => $this->scopeConfig->getValue(
                        'trans_email/ident_'. self::TEST_FROM_EMAIL .'/name',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                    'email' => $this->scopeConfig->getValue(
                        'trans_email/ident_'. self::TEST_FROM_EMAIL .'/email',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                ])
                ->addTo(self::TEST_TO_EMAIL)
                ->getTransport()
                ->sendMessage();

            echo "Email con allegato inviata!";
        } catch (MailException $me) {
            throw new \Exception($me->getMessage());
        } catch (\Exception $e) {
            throw new \Exception($e->getMessage());
        }
    }
}