<?php
namespace Drop\DisablePaymentFrontend\Observer;
use Magento\Framework\Event\ObserverInterface;
use Drop\DisablePaymentFrontend\Helper\Data;

class PaymentMethodAvailable implements ObserverInterface
{

    /**
     * @var Data
     */
    private $helper;

    public function __construct(Data $helper)
    {
        $this->helper = $helper;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if($this->isadmin()){
            return;
        }

        $paymentMethodCode = $observer->getEvent()->getMethodInstance()->getCode();
        if(in_array($paymentMethodCode, $this->helper->getDisabledFrontendPayments())){
            $checkResult = $observer->getEvent()->getResult();
            //this is disabling the payment method at checkout page
            $checkResult->setData('is_available', false);
        }
    }

    function isadmin($store = null) {
        /** @var \Magento\Framework\ObjectManagerInterface $om */
        $om = \Magento\Framework\App\ObjectManager::getInstance();
        /** @var \Magento\Framework\App\State $state */
        $state =  $om->get('Magento\Framework\App\State');
        return 'adminhtml' === $state->getAreaCode();
    }
}