<?php
/**
 *
 * Copyright © Drop s.r.l, All rights reserved.
 * @author Enrico Pascucci
 */
namespace Drop\BetterMagento\Controller\Account;

class LogoutSuccess
{

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     */
    public function __construct(
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\App\Response\Http $response
    ) {
        $this->storeManager = $storeManager;
        $this->response = $response;
        //$this->messageManager = $context->getMessageManager();
    }
    /**
     * Logout success page
     *
     * @return \Magento\Framework\View\Result\Page
     */
    public function beforeExecute()
    {
        //$this->messageManager->addSuccess(__('You are logged out'));
        $homeUrl = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_WEB,true);
        $this->response->setRedirect($homeUrl);
        return $this;
        //return $this->resultPageFactory->create();
    }
}