<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Drop\BetterMagento\Ui\DataProvider\Product;

use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;

/**
 * Class ProductDataProvider
 *
 * @api
 * @since 100.0.2
 */
class ProductDataProvider extends \Magento\Catalog\Ui\DataProvider\Product\ProductDataProvider
{

    /**
     * {@inheritdoc}
     */
    public function addFilter(\Magento\Framework\Api\Filter $filter)
    {
        if (isset($this->addFilterStrategies[$filter->getField()])) {
            $this->addFilterStrategies[$filter->getField()]
                ->addFilter(
                    $this->getCollection(),
                    $filter->getField(),
                    [$filter->getConditionType() => $filter->getValue()]
                );
        } elseif ('sku' == $filter->getField() && false !== strpos($filter->getValue(), ' ')) {

            $skus = explode(' ', substr($filter->getValue(), 1, strlen($filter->getValue())-2));
            $conditions = [[]];
            foreach($skus as $k => $v) {
                if (!empty($v)) $conditions[0][] = ['like' => '%' . $v . '%'];
            }
            $this->getCollection()->addFieldToFilter(
                'sku',
                $conditions
            );

        } else {
            parent::addFilter($filter);
        }
    }
}
