<?php

/**
 * @author Enrico Pascucci
 * @email e.pascucci@gmail.com
 * @copyright Drop s.r.l 2020
 */

namespace Drop\BetterXtento\Model\Export\Entity;

use Magento\Framework\Exception\LocalizedException;

class Product extends \Xtento\ProductExport\Model\Export\Entity\Product {

    public function runExport($forcedCollectionItem = false) {
        if ($this->getProfile()) {
            if ($this->getProfile()->getStoreId()) {
                //$this->storeManager->setCurrentStore($this->getProfile()->getStoreId());  // fixes catalog price rules
                $store = $this->storeManager->getStore($this->getProfile()->getStoreId());
                if ($store->getId()) {
                    $websiteId = $store->getWebsiteId();
                } else {
                    throw new LocalizedException(__('Product export failed. The specified store_id %1 does not exist anymore. Please update the profile in the Stores & Filters tab and select a valid store view.', $this->getProfile()->getStoreId()));
                }
                $this->collection->getSelect()->joinLeft(
                    $this->resourceConnection->getTableName('catalog_product_index_price') . ' AS price_index',
                    'price_index.entity_id=e.entity_id AND customer_group_id=0 AND price_index.website_id=' . $websiteId,
                    [
                        'min_price' => 'min_price',
                        'max_price' => 'max_price',
                        'tier_price' => 'tier_price',
                        'final_price' => 'final_price',
                        'default_price' => 'price'
                    ]
                );
                $this->collection->addStoreFilter($this->getProfile()->getStoreId());
                $this->collection->setStore($this->getProfile()->getStoreId());
                $this->collection->/*setStore($this->getProfile()->getStoreId())->addWebsiteFilter(Mage::app()->getStore($this->getProfile()->getStoreId())->getWebsiteId())->*/
                addAttributeToSelect("tax_class_id");
            }
            /** Add product reviews */
            /*
            $this->collection->getSelect()->joinLeft(
                $this->resourceConnection->getTableName('review_entity_summary') . ' AS reviews',
                'reviews.entity_pk_value=e.entity_id AND customer_group_id=0 AND reviews.store_id=' . $store->getId(),
                [
                    'reviews_count' => 'reviews_count',
                    'rating_summary' => 'rating_summary'
                ]
            );
            */
            if ($this->getProfile()->getOutputType() == 'csv' || $this->getProfile()->getOutputType() == 'xml') {
                // Fetch all fields
                $this->collection->addAttributeToSelect('*');
            } else {
                $attributesToSelect = explode(",", $this->getProfile()->getAttributesToSelect());
                if (empty($attributesToSelect) || (isset($attributesToSelect[0]) && empty($attributesToSelect[0]))) {
                    $attributes = '*';
                } else {
                    // Get all attributes which should be always fetched
                    $attributes = ['entity_id', 'sku', 'price', 'name', 'status', 'url_key', 'type_id', 'image'];
                    $attributes = array_merge($attributes, $attributesToSelect);
                    $attributes = array_unique($attributes);
                }
                $this->collection->addAttributeToSelect($attributes);
            }
            #echo($this->collection->getSelect());
            if ($this->getProfile()->getExportFilterProductVisibility() != '') {
                $this->collection->addAttributeToFilter(
                    'visibility',
                    ['in' => explode(",", $this->getProfile()->getExportFilterProductVisibility())]
                );
            }
            if ($this->getProfile()->getExportFilterProductStatus() != '') {
                $this->collection->addAttributeToFilter(
                    'status',
                    ['in' => explode(",", $this->getProfile()->getExportFilterProductStatus())]
                );
            }
            if ($this->getProfile()->getExportFilterInstockOnly() === "1") {
                $this->stockHelper->addInStockFilterToCollection($this->collection);
            }
        }
        return parent::runExport($forcedCollectionItem);
    }
}