<?php

/**
 * Product:       Xtento_ProductExport
 * ID:            %!uniqueid!%
 * Last Modified: 2016-04-17T13:01:31+00:00
 * File:          Observer/AbstractEventObserver.php
 * Copyright:     Copyright (c) XTENTO GmbH & Co. KG <info@xtento.com> / All rights reserved.
 */

namespace Drop\BetterXtento\Observer;

use Xtento\ProductExport\Model\Export;

class AbstractEventObserver extends \Xtento\ProductExport\Observer\AbstractEventObserver
{
    const EVENT_CATALOGRULE_SAVE_AFTER = 3;
    const EVENT_CATALOGRULE_APPLYALL_AFTER = 4;

    /**
     * Get export events
     *
     * @param bool|false $entity
     * @param bool|false $allEvents
     * @return array
     */
    public function getEvents($entity = false, $allEvents = false)
    {
        $events = [];

        // Events where product information can be exported
        if ($allEvents || $entity == Export::ENTITY_PRODUCT) {
            $events[Export::ENTITY_PRODUCT][parent::EVENT_CATALOG_PRODUCT_SAVE_AFTER] = [
                'event' => 'catalog_product_save_after',
                'label' => __('After product gets saved (Event: catalog_product_save_after)'),
                'method' => 'getProduct()',
                'force_collection_item' => true
            ];
            $events[Export::ENTITY_PRODUCT][self::EVENT_CATALOGRULE_SAVE_AFTER] = [
                'event' => 'catalogrule_rule_save_after',
                'label' => __('After rule gets saved (Event: catalogrule_rule_save_after)'),
                'method' => 'getCatalogRule()',
                'force_collection_item' => true
            ];
            $events[Export::ENTITY_PRODUCT][self::EVENT_CATALOGRULE_APPLYALL_AFTER] = [
                'event' => 'catalogrule_rule_applyallrules_after',
                'label' => __('After all rules are applied (Event: catalogrule_rule_applyallrules_after)'),
                'method' => 'getCatalogRule()',
                'force_collection_item' => true
            ];
        }
        // Events where category information can be exported
        if ($allEvents || $entity == Export::ENTITY_CATEGORY) {
            $events[Export::ENTITY_CATEGORY][parent::EVENT_CATALOG_CATEGORY_SAVE_AFTER] = [
                'event' => 'catalog_category_save_after',
                'label' => __('After category gets saved (Event: catalog_category_save_after)'),
                'method' => 'getCategory()',
                'force_collection_item' => true
            ];
        }

        // Third party events
        // None at this time

        return $events;
    }

    protected function executeCron($eventId, $entityId) {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $cronConfig = $objectManager->get('\Magento\Cron\Model\ConfigInterface');

        $profileCollection = $this->profileCollectionFactory->create()
            ->addFieldToFilter('enabled', 1) // Profile enabled
            ->addFieldToFilter('entity', $entityId)
            ->addFieldToFilter('event_observers', ['like' => '%' . $eventId . '%']); // Event enabled "pre-check"

        $targetJobs = [];
        $jobs = $cronConfig->getJobs();

        foreach($profileCollection as $profile) {
            $jobname = 'xtento_productexport_profile_' . $profile->getProfileId() . '_cron';
            foreach($jobs['default'] as $k => $job) {
                if (false !== strpos($k, $jobname)) {
                    $targetJobs[] = $k;
                    break;
                }
            }
        }
        foreach($targetJobs as $job) {
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $schedule = $objectManager->get('\Magento\Cron\Model\Schedule');
            $time = time();
            try {
                $schedule->setJobCode($job)
                    ->setCreatedAt($time)
                    ->setScheduledAt($time)
                    ->setStatus(\Magento\Cron\Model\Schedule::STATUS_PENDING)
                    ->save();
            } catch (Exception $e) {
                throw new Exception(Mage::helper('cron')->__('Unable to save Cron expression'));
            }
        }
    }
}
