define([
    'jquery',
    'Magento_Ui/js/modal/modal',
    'mage/cookies'
], function ($, modal) {
    'use strict';

    $.widget('drop.betternewsletter', {
        options: {
            footerNewsletterForm: $('#newsletter-validate-detail'),
            cookieName: 'cookie-popup',
            modal_opt: {
                type: 'popup',
                responsive: true,
                innerScroll: false,
                opened: function() {
                    $(".modal-footer").hide();
                }
            }
        },
        open: function (emailAddress) {
            if (emailAddress!=undefined) {
                $("input[type='email']", this.element).val(emailAddress);
            }

            this.element.modal(this.options.slide_opt)
            this.element.modal("openModal");
        },
        openFirstTime: function () {
            if ($.cookie(this.options.cookieName) == null) {
                this.open();
                $.cookie(this.options.cookieName, '1');
            }
        },
        _init: function (element) {
            var config = this.options;
            var element = this.element;

            if (config.isNewsletterPopupEnabled == 1) {
                this.openFirstTime();
            }

            var _this = this;

            this.options.footerNewsletterForm.submit(function (ev) {
                ev.preventDefault();
                var email = $("input[type='email']", $(this)).val();
                $("input[type='email']", element).val(email);
                _this.open();
            });
        }
    });
    return $.drop.betternewsletter;
});
