<?php

namespace Drop\BetterNewsletter\Setup;

use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;

/**
 * @codeCoverageIgnore
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $connection = $installer->getConnection();
        $table = $setup->getTable('newsletter_subscriber');

        if (version_compare($context->getVersion(), '1.1.0') < 0) {
            $connection->addColumn(
                $table,
                'subscriber_provenance_sorgente',
                [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'length' => 255,
                    'nullable' => true,
                    'default' => NULL,
                    'comment' => 'Subscriber Provenance Sorgente'
                ]
            );
            $connection->addColumn(
                $table,
                'subscriber_provenance_mezzo',
                [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'length' => 255,
                    'nullable' => true,
                    'default' => NULL,
                    'comment' => 'Subscriber Provenance Mezzo'
                ]
            );
            $connection->addColumn(
                $table,
                'subscriber_provenance_contenuto',
                [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'length' => 255,
                    'nullable' => true,
                    'default' => NULL,
                    'comment' => 'Subscriber Provenance Contenuto'
                ]
            );
        }
    }
}
