<?php
/**
 * @author Enrico Pascucci
 * @Copyright Drop s.r.l 2020
 * Date: 14/09/20
 * Time: 10.47
 */

namespace Drop\BetterNewsletter\Plugin\Model\Newsletter;

use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Customer\Api\Data\CustomerInterfaceFactory;



class Subscriber
{
    /** @var CustomerRepositoryInterface $customerRepository */
    private $customerRepository;

    /** @var \Magento\Framework\App\Request\Http $request */
    private $request;

    public function __construct(
        CustomerInterfaceFactory $customerFactory = null,
        CustomerRepositoryInterface $customerRepository,
        \Magento\Framework\App\Request\Http $request
    ) {
        $this->customerFactory = $customerFactory ?: ObjectManager::getInstance()->get(CustomerInterfaceFactory::class);
        $this->customerRepository = $customerRepository;
        $this->request = $request;
    }

    public function afterSubscribeCustomerById($subject, $result) {

        $postData = $this->request->getPost();

        if (!array_key_exists('is_subscribed', $postData)) return $result;

        if (array_key_exists('subscriber_provenance_sorgente', $postData))
            $subject->setData('subscriber_provenance_sorgente', $postData['subscriber_provenance_sorgente']);
        if (array_key_exists('subscriber_provenance_mezzo', $postData))
            $subject->setData('subscriber_provenance_mezzo', $postData['subscriber_provenance_mezzo']);
        if (array_key_exists('subscriber_provenance_contenuto', $postData))
            $subject->setData('subscriber_provenance_contenuto', $postData['subscriber_provenance_contenuto']);


        $customerData = $this->customerRepository->getById($subject->getCustomerId());

        $subject->setData('subscriber_gender', $customerData->getGender());

        $subject->save();

        return $result;
    }
}