<?php


namespace Drop\BetterNewsletter\Observer\Newsletter;

class SubscribedRemoveBlock implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * @var \Magento\Customer\Model\Session
     */
    private $customerSession;
    /**
     * @var \Magento\Newsletter\Model\Subscriber
     */
    private $subscriber;

    /**
     * SubscribedRemoveBlock constructor.
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Newsletter\Model\Subscriber $subscriber
     */
    public function __construct(
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Newsletter\Model\Subscriber $subscriber
    )
    {
        $this->customerSession = $customerSession;
        $this->subscriber = $subscriber;
    }

    /**
     * Execute observer
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(
        \Magento\Framework\Event\Observer $observer
    ) {
        $customerId = $this->customerSession->getCustomer()->getId();
        if(!$customerId) {
            return false;
        }
        $subscriber = $this->subscriber->loadByCustomerId($customerId);
        if($subscriber->isSubscribed()) {
            $layout = $observer->getLayout();
            $layout->unsetElement('form.subscribe');
        }
    }
}
