<?php

namespace Drop\BetterNewsletter\Model;

class RecaptchaPlugin extends \Magento\Framework\View\Element\Template
{

    public function beforeFetchView() {
        $parent = $this->getNameInLayout();
        if(empty($parent)) {
            $parent = 'betternewsletter.form.newsletter';
        }
        $block = 'MSP\ReCaptcha\Block\Frontend\ReCaptcha';
        $alias = 'newsletter-msp-recaptcha-' . rand();
        $arguments = [
            'data' => [
                'jsLayout' => [
                    'components' => [
                        'msp-recaptcha' => [
                            'component' => 'MSP_ReCaptcha/js/reCaptcha',
                            'zone' => 'newsletter'
                        ]
                    ]
                ]
            ]
        ];
        $template = 'MSP_ReCaptcha::msp_recaptcha.phtml';

        if(!in_array($alias, $this->getChildNames())) {
            $recaptchaBlock = $this->getLayout()->createBlock($block, $alias, $arguments)->setTemplate($template);
            if($recaptchaBlock && $this->getLayout()->getBlock($parent)) {
                try {
                    $this->setNameInLayout('newsletter.form.additional.info')->setChild($parent, $recaptchaBlock);
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }

}
