<?php

namespace Drop\BetterNewsletter\Block\Newsletter;

class Manage extends \Magento\Customer\Block\Newsletter
{

    /**
     * @var \Magento\Newsletter\Model\Subscriber
     */
    protected $subscription;

    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $customerSession;

    /**
     * @var \Magento\Newsletter\Model\SubscriberFactory
     */
    protected $subscriberFactory;

    /**
     * @var CustomerRepositoryInterface
     */
    protected $customerRepository;

    /**
     * @var AccountManagementInterface
     */
    protected $customerAccountManagement;

    /**
     * @var \Drop\BetterNewsletter\Helper\Data
     */
    protected $helperData;

    /**
     * @var string
     */
    protected $_template = 'form/newsletter.phtml';


    /**
     * Constructor
     *
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Newsletter\Model\SubscriberFactory $subscriberFactory
     * @param \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository
     * @param \Magento\Customer\Api\AccountManagementInterface $customerAccountManagement
     * @param \Drop\BetterNewsletter\Helper\Data $helperDat
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Newsletter\Model\SubscriberFactory $subscriberFactory,
        \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository,
        \Magento\Customer\Api\AccountManagementInterface $customerAccountManagement,
        \Drop\BetterNewsletter\Helper\Data $helperData,
        array $data = []
    ) {
        $this->helperData = $helperData;
        $this->customerSession = $customerSession;
        parent::__construct($context, $customerSession, $subscriberFactory, $customerRepository, $customerAccountManagement, $data);
    }

    /**
     * Custom list name
     * @return string
     */
    public function getNewsletterListName() {
        return $this->helperData->getListName();
    }

	public function getEmail()
	{
		return $this->getSessionCustomer()->getEmail();
	}
	public function getGender()
	{
		$customer = $this->getSessionCustomer();
		return __($customer->getAttribute('gender')->getSource()->getOptionText($customer->getData('gender')));
	}

	private function getSessionCustomer()
	{
		return $this->customerSession->getCustomer();
	}

}
