<?php

namespace Drop\BetterNewsletter\Setup;

use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

class InstallSchema implements InstallSchemaInterface
{

    /**
     *
     * {@inheritDoc}
     * @see \Magento\Framework\Setup\InstallSchemaInterface::install()
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();
        $connection = $installer->getConnection();

        /**
         * Newsletter additional fields
         */
        $table = $setup->getTable('newsletter_subscriber');
        $connection->addColumn(
            $table,
            'subscriber_firstname',
            [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'length' => 255,
                'nullable' => true,
                'comment' => 'Subscriber Firstname'
            ]
        );
        $connection->addColumn(
            $table,
            'subscriber_lastname',
            [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'length' => 255,
                'nullable' => true,
                'comment' => 'Subscriber lastname'
            ]
        );
        $connection->addColumn(
            $table,
            'subscriber_dob',
            [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'length' => 255,
                'nullable' => true,
                'comment' => 'Subscriber Dob'
            ]
        );
        $connection->addColumn(
            $table,
            'subscriber_gender',
            [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                'length' => 11,
                'nullable' => false,
                'default' => 0,
                'comment' => 'Subscriber Gender'
            ]
        );

        $installer->endSetup();
    }
}
