<?php

namespace Drop\BetterNewsletter\Model;

use \Magento\Framework\Message\ManagerInterface;
use \Magento\Newsletter\Model\Subscriber;
use \Drop\BetterNewsletter\Logger\Logger;
use Magento\Framework\Exception\LocalizedException;
use \Magento\Contact\Controller\Index\Post;
use \Magento\Framework\Controller\Result\RedirectFactory;

class ContactPlugin
{

    /**
     * @var ManagerInterface
     */
    protected $messageManager;

    /**
     * @var Subscriber
     */
    protected $subscriber;

    /**
     * @var RedirectFactory
     */
    protected $resultRedirectFactory;

    /**
     * @var Logger
     */
    protected $logger;

    /**
     * @param ManagerInterface $messageManager
     * @param Logger $logger
     */
    public function __construct(
        ManagerInterface $messageManager,
        Subscriber $subscriber,
        RedirectFactory $resultRedirectFactory,
        Logger $logger
    ) {
        $this->messageManager = $messageManager;
        $this->subscriber = $subscriber;
        $this->resultRedirectFactory = $resultRedirectFactory;
        $this->logger = $logger;
    }

    public function afterExecute(Post $subject, $result) {
        $request = $subject->getRequest();
        if (empty($request->getPostValue())) {
            return $this->resultRedirectFactory->create()->setPath('contact/index');
        }

        try {
            if(!$params = $this->validatedParams($request)) {
                return $this->resultRedirectFactory->create()->setPath('contact/index');
            }
            $this->subscriber->subscribe($params['email']);
            $this->messageManager->addSuccessMessage(__('Thank you for your subscription.'));
        } catch (LocalizedException $e) {
            $this->logger->critical($e->getMessage());
            $this->messageManager->addErrorMessage($e->getMessage());
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
            $this->messageManager->addErrorMessage(__('An error occurred while subscribing to the newsletter. Please try again later.'));
        }

        return $this->resultRedirectFactory->create()->setPath('contact/index');
    }

    /**
     * @return array
     * @throws \Exception
     */
    private function validatedParams($request)
    {
        if (false === \strpos($request->getParam('email'), '@')) {
            throw new LocalizedException(__('Invalid email address'));
        }
        if (trim($request->getParam('is_subscribed')) !== '1') {
            return false;
        }

        return $request->getParams();
    }

}
