<?php

namespace Drop\BetterNewsletter\Helper;

use Magento\Store\Model\ScopeInterface;
use \Magento\Framework\App\Helper\Context;
use \Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use \Magento\Store\Model\StoreManagerInterface;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{

    const XML_PATH_NEWSLETTER_SUBSCRIPTION_OPEN_POPUP = 'newsletter/subscription/allow_popup_subscribe';
    const XML_PATH_NEWSLETTER_SUBSCRIPTION_LIST_NAME = 'newsletter/subscription/list_name';

    const XML_NEWSLETTER_PAGE_META_TITLE_CONFIG_PATH = 'newsletter/page/meta_title';
    const XML_NEWSLETTER_PAGE_META_DESCRIPTION_CONFIG_PATH = 'newsletter/page/meta_description';
    const XML_NEWSLETTER_PAGE_META_KEYWORDS_CONFIG_PATH = 'newsletter/page/meta_keywords';
    const XML_NEWSLETTER_PAGE_BREADCRUMBS_CONFIG_PATH = 'newsletter/page/breadcrumbs';

    const DEFAULT_MAGENTO_DATE_FORMAT = 'Y/m/d';

    /**
     * @var TimezoneInterface
     */
    protected $timezone;

    /**
     * @var  StoreManagerInterface

     */
    protected $storemanager;

    public function __construct(
        Context $context,
        TimezoneInterface $timezone,
        StoreManagerInterface $storemanager
    ) {
        $this->timezone = $timezone;
        $this->storemanager = $storemanager;

        parent::__construct($context);
    }

    /**
     * Retrieve scope config data
     *
     * @param $path
     * @param string $scopeType
     * @param null $scopeCode
     * @return string
     */
    public function getScopeConfig(
        $path,
        $scopeType = ScopeInterface::SCOPE_STORE,
        $scopeCode = null
    ) {
        return $this->scopeConfig->getValue($path, $scopeType, $scopeCode);
    }

    public function getAllowPopupSubscribe() {
        return $this->getScopeConfig(self::XML_PATH_NEWSLETTER_SUBSCRIPTION_OPEN_POPUP);
    }

    public function getListName() {
        return $this->getScopeConfig(self::XML_PATH_NEWSLETTER_SUBSCRIPTION_LIST_NAME);
    }

    public function getNewsletterPageMetaTitle() {
        return $this->getScopeConfig(self::XML_NEWSLETTER_PAGE_META_TITLE_CONFIG_PATH);
    }

    public function getNewsletterPageMetaDescription() {
        return $this->getScopeConfig(self::XML_NEWSLETTER_PAGE_META_DESCRIPTION_CONFIG_PATH);
    }

    public function getNewsletterPageMetaKeywords() {
        return $this->getScopeConfig(self::XML_NEWSLETTER_PAGE_META_KEYWORDS_CONFIG_PATH);
    }

    public function getNewsletterPageBreadcrumb() {
        return $this->scopeConfig->isSetFlag(self::XML_NEWSLETTER_PAGE_BREADCRUMBS_CONFIG_PATH, ScopeInterface::SCOPE_STORE);
    }

    public function getDobDateFormatted($date) {
        $stringDate = strtotime(str_replace('/', '-', $date));
        if(empty($stringDate)) {
            return false;
        }

        $dateTime = new \DateTime();
        $dateTime->setTimestamp($stringDate);
        return $this->timezone->date($dateTime)->format(self::DEFAULT_MAGENTO_DATE_FORMAT);
    }

    public function getHomeUrl() {
        return $this->storemanager->getStore()->getBaseUrl();
    }

}
