<?php

namespace Drop\BetterNewsletter\Controller\Unsubscribe;

use \Magento\Framework\App\Action\Action;
use \Magento\Framework\App\Action\Context;
use \Magento\Newsletter\Model\SubscriberFactory;
use \Magento\Framework\View\Result\PageFactory;
use \Drop\BetterNewsletter\Logger\Logger;
use \Magento\Framework\Exception\LocalizedException;
use \Drop\BetterNewsletter\Helper\Data;

class Confirm extends Action
{

    /**
    * @var PageFactory
     */
    public $resultPageFactory;

    /**
    * @var SubscriberFactory
     */
    public $subscriberFactory;

    /**
    * @var Data
     */
    public $helperData;

    /**
    * @var Logger
     */
    public $logger;

    /**
     * @param Context $context
     * @param SubscriberFactory $subscriberFactory
     * @param PageFactory $resultPageFactory
     */
    public function __construct(
        Context $context,
        SubscriberFactory $subscriberFactory,
        PageFactory $resultPageFactory,
        Data $helperData,
        Logger $logger
    ) {
        parent::__construct($context);
        $this->subscriberFactory = $subscriberFactory;
        $this->resultPageFactory = $resultPageFactory;
        $this->helperData = $helperData;
        $this->logger = $logger;
    }

    /**
     * Unsubscribe confirmation page
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|\Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $id = (int) $this->getRequest()->getParam('id');
        $code = (string) $this->getRequest()->getParam('code');

        if ($id && $code) {
            try {
                $subscriber = $this->subscriberFactory->create()->load($id);
                if(!$subscriber->getId()) {
                    throw new LocalizedException(__('Subscriber does not exist anymore.'));
                }

                if($subscriber->getCode() != $code) {
                    throw new LocalizedException(__('Something went wrong while unsubscribing you.'));
                }

                if($subscriber->isSubscribed()) {
                    /** @var \Magento\Framework\View\Result\Page $resultPage */
                    $resultPage = $this->resultPageFactory->create();
                    $resultPage->getLayout()
                        ->getBlock('betternewsletter.newsletter.unsubscribe')
                        ->setSubscriberId($id)
                        ->setSubscriberCode($code);
                    $pageTitle = __('Newsletter unsubscribe');
                    $resultPage->getConfig()->getTitle()->set($pageTitle);
                    if ($this->helperData->getNewsletterPageBreadcrumb()) {
                        /** @var \Magento\Theme\Block\Html\Breadcrumbs $breadcrumbsBlock */
                        $breadcrumbsBlock = $resultPage->getLayout()->getBlock('breadcrumbs');
                        if ($breadcrumbsBlock) {
                            $breadcrumbsBlock->addCrumb('home',['label' => __('Home'), 'link' => $this->_url->getUrl('')]);
                            $breadcrumbsBlock->addCrumb('unsubscribe',['label' => $pageTitle,]);
                        }
                    }
                    return $resultPage;
                }
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->logger->critical($e->getMessage());
                $this->messageManager->addErrorMessage($e->getMessage());
            }
        }
        $this->getResponse()->setRedirect($this->helperData->getHomeUrl());
    }

}
