<?php

namespace Drop\BetterNewsletter\Block;

class Newsletter extends \Magento\Newsletter\Block\Subscribe
{

    /**
     * @var \Magento\Framework\Module\Manager
     */
    protected $_moduleManager;
    /**
     * @var \Magento\Newsletter\Model\SubscriberFactory
     */
//    private $subscriberFactory;
    /**
     * @var \Magento\Customer\Model\Session
     */
    private $customerSession;
    /**
     * @var \Drop\BetterNewsletter\Helper\Data
     */
    private $helper;
    /**
     * @var \Magento\Cms\Model\Page
     */
    private $cmsPage;

    /**
     * Newsletter constructor.
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Framework\Module\Manager $moduleManager
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Drop\BetterNewsletter\Helper\Data $helper
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Framework\Module\Manager $moduleManager,
        \Magento\Customer\Model\Session $customerSession,
        \Drop\BetterNewsletter\Helper\Data $helper,
        \Magento\Cms\Model\Page $cmsPage
//        \Magento\Newsletter\Model\SubscriberFactory $subscriberFactory
    ) {
        $this->_moduleManager = $moduleManager;
        $this->customerSession = $customerSession;
//        $this->subscriberFactory = $subscriberFactory;
        $this->helper = $helper;
        $this->cmsPage = $cmsPage;
        parent::__construct($context);
    }

    /**
     * Newsletter module availability
     *
     * @return bool
     */
    public function isNewsletterEnabled()
    {
        return $this->_moduleManager->isOutputEnabled('Magento_Newsletter');
    }

    public function isNewsletterPopupEnabled() {
        return $this->helper->getAllowPopupSubscribe();
    }

    /**
     * @return bool
     */
//    public function getIsSubscribed()
//    {
//        $subscriberModel = $this->subscriberFactory->create();
//        $customer = $subscriberModel->loadByCustomerId($this->customerSession->getCustomerId());
//        if ($customer->getId() && $customer->getStatus() == \Magento\Newsletter\Model\Subscriber::STATUS_SUBSCRIBED) {
//            return true;
//        }
//        return false;
//    }

    /**
     * Retrieve form data
     *
     * @return mixed
     */
    public function getFormData()
    {
        $data = $this->getData('form_data');
        if ($data === null) {
            $formData = $this->customerSession->getCustomerFormData(true);
            $data = new \Magento\Framework\DataObject();
            if ($formData) {
                $data->addData($formData);
                $data->setCustomerData(1);
            }
            if (isset($data['region_id'])) {
                $data['region_id'] = (int)$data['region_id'];
            }
            $this->setData('form_data', $data);
        }
        return $data;
    }

    public function canIncludeNewsletterPopup() {
        if(($this->cmsPage->getIdentifier() != 'newsletter') &&
            ($this->getRequest()->getFullActionName() != 'customer_account_create') &&
            ($this->getRequest()->getRouteName()) != 'newsletter') {
            return true;
        }
        return false;
    }

}
