<?php

namespace Drop\BetterNewsletter\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Newsletter\Model\SubscriberFactory;
use \Magento\Newsletter\Model\Subscriber;
use \Magento\Framework\App\RequestInterface;
use \Drop\BetterNewsletter\Logger\Logger;

class NewsletterSubscription implements ObserverInterface
{
    /**
     * @var SubscriberFactory
     */
    private $subscriberFactory;
    /**
     * @var Logger
     */
    private $logger;
    /**
     * @var RequestInterface
     */
    private $request;

    const CHECKOUT_SORGENTE = 'sorgente_ecommerce';
    const CHECKOUT_MEZZO = 'mezzo_checkout';
    const CHECKOUT_CONTENUTO = 'contenuto_purchase';

    public function __construct(
        SubscriberFactory $subscriberFactory,
        RequestInterface $request,
        Logger $logger
    ) {
        $this->subscriberFactory = $subscriberFactory;
        $this->logger = $logger;
        $this->request = $request;
    }
    public function execute(\Magento\Framework\Event\Observer $observer)
    {

        /** @var $quote \Magento\Quote\Model\Quote $quote */
        $quote = $observer->getEvent()->getQuote();
        if ($quote->getCustomerEmail()
            && (bool)$quote->getData(\Drop\BetterNewsletter\Model\Data\NewsletterSubscription::NEWSLETTER_SUBSCRIPTION)
        ) {

            try {
                $this->request->setPostValue('email', $quote->getCustomerEmail());
                $this->request->setPostValue('subscriber_email', $quote->getCustomerEmail());
                $this->request->setPostValue('subscriber_firstname', $quote->getCustomerFirstname());
                $this->request->setPostValue('subscriber_lastname', $quote->getCustomerLastname());

                $this->request->setPostValue('subscriber_dob', $quote->getCustomerDob());
                $this->request->setPostValue('subscriber_gender', $quote->getCustomerGender());

                $this->request->setPostValue('subscriber_provenance_sorgente', self::CHECKOUT_SORGENTE);
                $this->request->setPostValue('subscriber_provenance_mezzo', self::CHECKOUT_MEZZO);
                $this->request->setPostValue('subscriber_provenance_contenuto', self::CHECKOUT_CONTENUTO);

                $this->getSubscriberFactory()->subscribe($quote->getCustomerEmail());
            } catch (\Exception $e) {
                $this->logger->critical($e->getMessage());
            }
        }
    }
    /**
     * @return \Magento\Newsletter\Model\Subscriber
     */
    private function getSubscriberFactory()
    {
        return $this->subscriberFactory->create();
    }
}
